/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import io.dangernoodle.slack.client.SlackClientBuilder;
import io.dangernoodle.slack.client.SlackClientSettings;
import io.dangernoodle.slack.client.SlackConnectionMonitor;
import io.dangernoodle.slack.client.SlackConnectionSession;
import io.dangernoodle.slack.client.SlackSessionObservers;
import io.dangernoodle.slack.client.rtm.SlackObserverRegistry;
import io.dangernoodle.slack.client.rtm.SlackWebSocketClient;
import io.dangernoodle.slack.client.web.SlackWebClient;
import io.dangernoodle.slack.events.SlackEventType;
import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.SlackUser;
import io.dangernoodle.slack.objects.api.SlackPostMessage;
import io.dangernoodle.slack.objects.api.SlackStartRtmResponse;
import io.dangernoodle.slack.objects.api.SlackWebResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackClient {
    private static final Logger logger = LoggerFactory.getLogger(SlackClient.class);
    private final AtomicLong messageId = new AtomicLong();
    private final SlackConnectionMonitor monitor;
    private final SlackObserverRegistry registry;
    private final SlackWebSocketClient rtmClient;
    private final SlackConnectionSession session = this.createConnectionSession();
    private final SlackClientSettings settings;
    private final SlackWebClient webClient;

    SlackClient(SlackClientBuilder builder) {
        this.rtmClient = builder.getRtmClient(this);
        this.webClient = builder.getWebClient();
        this.settings = builder.getClientSettings();
        this.monitor = this.createConnectionMonitor();
        this.registry = this.createObserverRegistry();
        this.registerObservers();
    }

    public void connect() {
        this.monitor.start();
    }

    public void disconnet() {
        try {
            this.monitor.stop();
            this.rtmClient.disconnect();
        }
        catch (IOException e) {
            logger.warn("unexpected error disconnecting", (Throwable)e);
        }
    }

    public SlackObserverRegistry getObserverRegistry() {
        return this.registry;
    }

    public SlackConnectionSession getSession() {
        return this.session;
    }

    public SlackWebClient getWebClient() {
        return this.webClient;
    }

    public SlackUser getSelfUser() {
        return this.session.getSelfUser();
    }

    public boolean isConnected() {
        return this.rtmClient.isConnected();
    }

    public long send(SlackMessageable.Id id, String text) throws UncheckedIOException {
        return this.send(new SimpleMessage((long)this.nextMessageId(), (String)id.value(), (String)text)).id;
    }

    public long send(SlackMessageable.Id id, String format, Object ... args) throws UncheckedIOException {
        return this.send(id, String.format(format, args));
    }

    public SlackWebResponse send(SlackMessageable.Id id, SlackPostMessage.Builder builder) throws UncheckedIOException {
        try {
            return this.webClient.send(id, builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SlackConnectionMonitor createConnectionMonitor() {
        return new SlackConnectionMonitor(this, this.settings.getHeartbeat(), this.settings.reconnect());
    }

    SlackConnectionSession createConnectionSession() {
        return new SlackConnectionSession();
    }

    SlackObserverRegistry createObserverRegistry() {
        return new SlackObserverRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long reconnect() throws ConnectException, IOException {
        logger.trace("initiating slack rtm initiation request...");
        SlackStartRtmResponse response = this.webClient.initiateRtmConnection();
        if (!response.isOk()) {
            String error = response.getError();
            logger.error("failed to establish rtm session to slack: {}", (Object)error);
            throw new ConnectException(error);
        }
        SlackClient error = this;
        synchronized (error) {
            this.session.updateSession(response);
            this.rtmClient.connect(response.getUrl());
        }
        if (!this.rtmClient.isConnected()) {
            throw new ConnectException("websocket is not connected");
        }
        long nextMessageId = this.nextMessageId();
        this.session.updateLastPingId(nextMessageId);
        return nextMessageId;
    }

    long sendPing() {
        Map<String, String> args = this.settings.pingArgs();
        args.put("type", "ping");
        args.put("id", String.valueOf(this.nextMessageId()));
        args.put("time", String.valueOf(System.currentTimeMillis()));
        return Long.valueOf(this.send(args).get("id"));
    }

    private long nextMessageId() {
        return this.messageId.incrementAndGet();
    }

    private void registerObservers() {
        this.registry.addHelloObserver(SlackSessionObservers.helloObserver);
        this.registry.addPongObserver(SlackSessionObservers.pongObserver);
        this.registry.addGroupLeftObserver(SlackSessionObservers.groupLeftObserver);
        this.registry.addGroupJoinedObserver(SlackSessionObservers.groupJoinedObserver);
        this.registry.addChannelCreatedObserver(SlackSessionObservers.channelCreatedObserver);
        this.registry.addUserChangeObserver(SlackSessionObservers.userChangedObserver);
    }

    private <T> T send(T object) throws UncheckedIOException {
        try {
            this.rtmClient.send(object);
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class SimpleMessage {
        final String channel;
        final long id;
        final String text;
        final String type;

        SimpleMessage(long id, String channel, String text) {
            this.id = id;
            this.channel = channel;
            this.text = text;
            this.type = SlackEventType.MESSAGE.toType();
        }
    }
}

