/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import io.dangernoodle.slack.client.SlackClient;
import io.dangernoodle.slack.client.SlackClientSettings;
import io.dangernoodle.slack.client.SlackHttpDelegate;
import io.dangernoodle.slack.client.SlackJsonTransformer;
import io.dangernoodle.slack.client.SlackProviderFactory;
import io.dangernoodle.slack.client.rtm.SlackWebSocketAssistant;
import io.dangernoodle.slack.client.rtm.SlackWebSocketClient;
import io.dangernoodle.slack.client.web.SlackWebClient;
import java.util.ArrayList;
import java.util.ServiceLoader;

public class SlackClientBuilder {
    private static final ServiceLoaderDelegate serviceLoaderDelegate = new ServiceLoaderDelegate();
    private final SlackClientSettings clientSettings;
    private SlackHttpDelegate httpDelegate;
    private SlackJsonTransformer jsonTransformer;
    private SlackProviderFactory providerFactory;

    public SlackClientBuilder(SlackClientSettings clientSettings) {
        this.clientSettings = clientSettings;
    }

    public SlackClient build() {
        this.providerFactory = this.getSlackProviderFactory();
        this.httpDelegate = this.providerFactory.createHttpDelegate();
        this.jsonTransformer = this.providerFactory.createJsonTransformer();
        return new SlackClient(this);
    }

    public SlackClientBuilder with(SlackProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        return this;
    }

    SlackClientSettings getClientSettings() {
        return this.clientSettings;
    }

    SlackWebSocketClient getRtmClient(SlackClient slackClient) {
        SlackWebSocketAssistant assistant = new SlackWebSocketAssistant(slackClient, this.jsonTransformer, this.clientSettings);
        return this.providerFactory.createClient(assistant);
    }

    SlackWebClient getWebClient() {
        return new SlackWebClient(this.clientSettings, this.httpDelegate, this.jsonTransformer);
    }

    private SlackProviderFactory getSlackProviderFactory() {
        return this.providerFactory != null ? this.providerFactory : serviceLoaderDelegate.getSlackProviderFactory();
    }

    public static SlackClient createClient(SlackClientSettings settings) {
        return new SlackClientBuilder(settings).build();
    }

    private static class ServiceLoaderDelegate {
        private ServiceLoaderDelegate() {
        }

        SlackProviderFactory getSlackProviderFactory() throws IllegalStateException {
            ServiceLoader<SlackProviderFactory> pfLoader = ServiceLoader.load(SlackProviderFactory.class);
            ArrayList factories = new ArrayList();
            pfLoader.forEach(factories::add);
            if (factories.size() == 0) {
                throw new IllegalStateException("no instances of 'SlackProviderFactory' found on classpath");
            }
            if (factories.size() != 1) {
                throw new IllegalStateException("multiple instances of 'SlackProviderFactory' found on classpath");
            }
            return (SlackProviderFactory)factories.get(0);
        }
    }
}

