/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import java.util.HashMap;
import java.util.Map;

public class SlackClientSettings {
    private String authToken;
    private boolean dispatchMessageSubtypes;
    private boolean filterSelfMessages;
    private int heartbeat = 15;
    private final Map<String, String> pingArgs;
    private boolean reconnect;

    public SlackClientSettings(String authToken) {
        this.authToken = authToken;
        this.reconnect = true;
        this.dispatchMessageSubtypes = true;
        this.pingArgs = new HashMap<String, String>();
    }

    public boolean dispatchMessageSubtypes() {
        return this.dispatchMessageSubtypes;
    }

    public SlackClientSettings dispatchMessageSubtypes(boolean dispatch) {
        this.dispatchMessageSubtypes = dispatch;
        return this;
    }

    public boolean filterSelfMessages() {
        return this.filterSelfMessages;
    }

    public SlackClientSettings filterSelfMessages(boolean filterSelfMessages) {
        this.filterSelfMessages = filterSelfMessages;
        return this;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public SlackClientSettings heartbeat(int heartbeat) throws IllegalArgumentException {
        if (heartbeat < 1) {
            throw new IllegalArgumentException("heartbeat must be greater then 0");
        }
        this.heartbeat = heartbeat;
        return this;
    }

    public SlackClientSettings pingArg(String name, String value) {
        this.pingArgs.put(name, value);
        return this;
    }

    public Map<String, String> pingArgs() {
        return new HashMap<String, String>(this.pingArgs);
    }

    public boolean reconnect() {
        return this.reconnect;
    }

    public SlackClientSettings reconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return this;
    }
}

