/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import io.dangernoodle.slack.client.SlackClient;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackConnectionMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SlackConnectionMonitor.class);
    final int heartbeat;
    final boolean reconnect;
    private final SlackClient client;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> future;
    private long lastPingId;

    SlackConnectionMonitor(SlackClient client, int heartbeat, boolean reconnect) {
        this.client = client;
        this.heartbeat = heartbeat;
        this.reconnect = reconnect;
        this.executorService = this.createExecutorService();
    }

    protected void finalize() throws Throwable {
        this.executorService.shutdownNow();
        super.finalize();
    }

    ScheduledExecutorService createExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(this::createThread);
    }

    long getLastPingId() {
        return this.lastPingId;
    }

    void run() {
        if (this.client.isConnected() && this.lastPingId == this.client.getSession().getLastPingId()) {
            this.lastPingId = this.client.sendPing();
            logger.trace("connection ok, ping sent - id [{}]", (Object)this.lastPingId);
        } else if (this.reconnect) {
            logger.trace("issue with connection, reconnecting...");
            this.reconnect();
        } else {
            logger.warn("disconnected from slack, reconnect not enabled");
        }
    }

    synchronized void start() {
        logger.info("heartbeat thread started at interval of [{}] seconds", (Object)this.heartbeat);
        this.future = this.executorService.scheduleAtFixedRate(this::run, 0L, this.heartbeat, TimeUnit.SECONDS);
    }

    synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
            logger.info("hearbeat thread stopped");
        }
    }

    private Thread createThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("Slack-Hearbeat");
        return thread;
    }

    private void reconnect() {
        try {
            this.lastPingId = this.client.reconnect();
            logger.trace("recconnected, ping id [{}]", (Object)this.lastPingId);
        }
        catch (IOException e) {
            logger.warn("reconnection failed", (Throwable)e);
        }
    }
}

