/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import io.dangernoodle.slack.objects.SlackIntegration;
import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.SlackSelf;
import io.dangernoodle.slack.objects.SlackTeam;
import io.dangernoodle.slack.objects.SlackUser;
import io.dangernoodle.slack.objects.api.SlackStartRtmResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SlackConnectionSession {
    final Map<SlackMessageable.Id, SlackMessageable> channels;
    final Map<SlackIntegration.Id, SlackIntegration> integrations;
    final Map<SlackUser.Id, SlackUser> users;
    private final AtomicLong lastSentPingId = new AtomicLong();
    private SlackSelf self;
    private SlackTeam team;
    private SlackUser user;

    public SlackConnectionSession() {
        this.integrations = new ConcurrentHashMap<SlackIntegration.Id, SlackIntegration>(16, 0.9f, 1);
        this.users = new ConcurrentHashMap<SlackUser.Id, SlackUser>(16, 0.9f, 1);
        this.channels = new ConcurrentHashMap<SlackMessageable.Id, SlackMessageable>(16, 0.9f, 1);
    }

    public SlackMessageable findChannel(SlackMessageable.Id id) throws IllegalArgumentException {
        return this.findById(id, this.channels);
    }

    public SlackIntegration findIntegration(SlackIntegration.Id id) {
        return this.findById(id, this.integrations);
    }

    public SlackUser findUser(SlackUser.Id id) throws IllegalArgumentException {
        return this.findById(id, this.users);
    }

    public SlackUser getSelfUser() {
        return this.user;
    }

    public SlackTeam getTeam() {
        return this.team;
    }

    long getLastPingId() {
        return this.lastSentPingId.get();
    }

    void removeChannel(SlackMessageable.Id channelId) {
        this.channels.remove(channelId);
    }

    void updateChannels(SlackMessageable channel) {
        this.channels.put(channel.getId(), channel);
    }

    void updateIntegrations(SlackIntegration integration) {
        this.integrations.put(integration.getId(), integration);
    }

    void updateLastPingId(long id) {
        this.lastSentPingId.set(id);
    }

    synchronized void updateSession(SlackStartRtmResponse session) {
        this.self = session.getSelf();
        this.team = session.getTeam();
        this.channels.clear();
        session.getGroups().forEach(this::updateChannels);
        session.getChannels().forEach(this::updateChannels);
        session.getDirectMessages().forEach(this::updateChannels);
        session.getUsers().forEach(this::updateUsers);
        session.getIntegrations().forEach(this::updateIntegrations);
        this.user = this.findUser(this.self.getId());
    }

    void updateUsers(SlackUser user) {
        this.users.put(user.getId(), user);
    }

    private <I, T> T findById(I id, Map<I, T> map) {
        return map.get(id);
    }
}

