/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client;

import io.dangernoodle.slack.client.SlackConnectionSession;
import io.dangernoodle.slack.client.rtm.SlackEventObserver;
import io.dangernoodle.slack.events.SlackHelloEvent;
import io.dangernoodle.slack.events.SlackPongEvent;
import io.dangernoodle.slack.events.channel.SlackChannelCreatedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelJoinedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelLeftEvent;
import io.dangernoodle.slack.events.user.SlackUserChangeEvent;
import io.dangernoodle.slack.objects.SlackChannel;
import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.SlackTeam;
import io.dangernoodle.slack.objects.SlackUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SlackSessionObservers {
    private static final Logger logger = LoggerFactory.getLogger(SlackSessionObservers.class);
    static final SlackEventObserver<SlackChannelCreatedEvent> channelCreatedObserver = (event, client) -> {
        SlackChannel channel = event.getChannel();
        logger.debug("channel created event received, adding new channel [{}]", (Object)channel.getName());
        client.getSession().updateChannels(channel);
    };
    static final SlackEventObserver<SlackChannelJoinedEvent> groupJoinedObserver = (event, client) -> {
        SlackChannel channel = event.getChannel();
        logger.debug("group joined event received, adding private channel [{}]", (Object)channel.getName());
        client.getSession().updateChannels(channel);
    };
    static final SlackEventObserver<SlackChannelLeftEvent> groupLeftObserver = (event, client) -> {
        SlackMessageable.Id channel = event.getChannel();
        logger.debug("group left event received, removing private channel [{}]", (Object)channel.value());
        client.getSession().removeChannel(channel);
    };
    static final SlackEventObserver<SlackHelloEvent> helloObserver = (event, client) -> {
        SlackConnectionSession session = client.getSession();
        SlackTeam team = session.getTeam();
        logger.info("team: {} ({})", (Object)team.getName(), (Object)team.getId().value());
        SlackUser self = session.getSelfUser();
        logger.info("self: {} ({})", (Object)self.getName(), (Object)self.getId().value());
        logger.info("slack session established!");
    };
    static final SlackEventObserver<SlackPongEvent> pongObserver = (event, client) -> {
        client.getSession().updateLastPingId(event.getId());
        logger.debug("pong event received in {} ms", (Object)(System.currentTimeMillis() - event.getTime()));
    };
    static final SlackEventObserver<SlackUserChangeEvent> userChangedObserver = (event, client) -> {
        SlackUser user = event.getUser();
        logger.debug("user changed event received, updating user [{}]", (Object)user.getName());
        client.getSession().updateUsers(user);
    };

    private SlackSessionObservers() {
    }
}

