/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client.rtm;

import io.dangernoodle.slack.client.rtm.SlackEventObserver;
import io.dangernoodle.slack.events.SlackErrorEvent;
import io.dangernoodle.slack.events.SlackEvent;
import io.dangernoodle.slack.events.SlackEventType;
import io.dangernoodle.slack.events.SlackHelloEvent;
import io.dangernoodle.slack.events.SlackMessageEvent;
import io.dangernoodle.slack.events.SlackMessageEventType;
import io.dangernoodle.slack.events.SlackPongEvent;
import io.dangernoodle.slack.events.SlackReplyToEvent;
import io.dangernoodle.slack.events.SlackUnknownEvent;
import io.dangernoodle.slack.events.channel.SlackChannelCreatedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelDeletedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelJoinedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelLeftEvent;
import io.dangernoodle.slack.events.channel.SlackChannelRenameEvent;
import io.dangernoodle.slack.events.user.SlackUserChangeEvent;
import io.dangernoodle.slack.events.user.SlackUserTypingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SlackObserverRegistry {
    private final Map<SlackMessageEventType, Vector<SlackEventObserver<? extends SlackEvent>>> messageObservers;
    private final Map<SlackEventType, Vector<SlackEventObserver<? extends SlackEvent>>> observers = new ConcurrentHashMap<SlackEventType, Vector<SlackEventObserver<? extends SlackEvent>>>(8, 0.9f, 1);

    public SlackObserverRegistry() {
        this.messageObservers = new ConcurrentHashMap<SlackMessageEventType, Vector<SlackEventObserver<? extends SlackEvent>>>(8, 0.9f, 1);
    }

    public void addChannelCreatedObserver(SlackEventObserver<SlackChannelCreatedEvent> observer) {
        this.addObserver(SlackEventType.CHANNEL_CREATED, observer);
    }

    public void addChannelDeletedObserver(SlackEventObserver<SlackChannelDeletedEvent> observer) {
        this.addObserver(SlackEventType.CHANNEL_DELETED, observer);
    }

    public void addChannelJoinedObserver(SlackEventObserver<SlackChannelJoinedEvent> observer) {
        this.addObserver(SlackEventType.CHANNEL_JOINED, observer);
    }

    public void addChannelLeftObserver(SlackEventObserver<SlackChannelLeftEvent> observer) {
        this.addObserver(SlackEventType.CHANNEL_LEFT, observer);
    }

    public void addChannelRenameObserver(SlackEventObserver<SlackChannelRenameEvent> observer) {
        this.addObserver(SlackEventType.CHANNEL_RENAME, observer);
    }

    public void addErrorObserver(SlackEventObserver<SlackErrorEvent> observer) {
        this.addObserver(SlackEventType.ERROR, observer);
    }

    public void addGroupJoinedObserver(SlackEventObserver<SlackChannelJoinedEvent> observer) {
        this.addObserver(SlackEventType.GROUP_JOINED, observer);
    }

    public void addGroupLeftObserver(SlackEventObserver<SlackChannelLeftEvent> observer) {
        this.addObserver(SlackEventType.GROUP_LEFT, observer);
    }

    public void addGroupRenameObserver(SlackEventObserver<SlackChannelRenameEvent> observer) {
        this.addObserver(SlackEventType.GROUP_RENAME, observer);
    }

    public void addHelloObserver(SlackEventObserver<SlackHelloEvent> observer) {
        this.addObserver(SlackEventType.HELLO, observer);
    }

    public void addMessageChangedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.addObserver(SlackMessageEventType.MESSAGE_CHANGED, observer);
    }

    public void addMessageDeletedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.addObserver(SlackMessageEventType.MESSAGE_DELETED, observer);
    }

    public void addMessagePostedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.addObserver(SlackEventType.MESSAGE, observer);
    }

    public void addPongObserver(SlackEventObserver<SlackPongEvent> observer) {
        this.addObserver(SlackEventType.PONG, observer);
    }

    public void addReplyToObserver(SlackEventObserver<SlackReplyToEvent> observer) {
        this.addObserver(SlackEventType.REPLY_TO, observer);
    }

    public void addUnknownMessageObserver(SlackEventObserver<SlackUnknownEvent> observer) {
        this.addObserver(SlackMessageEventType.UNKNOWN, observer);
    }

    public void addUnknownObserver(SlackEventObserver<SlackUnknownEvent> observer) {
        this.addObserver(SlackEventType.UNKNOWN, observer);
    }

    public void addUserChangeObserver(SlackEventObserver<SlackUserChangeEvent> observer) {
        this.addObserver(SlackEventType.USER_CHANGE, observer);
    }

    public void addUserTypingObserver(SlackEventObserver<SlackUserTypingEvent> observer) {
        this.addObserver(SlackEventType.USER_TYPING, observer);
    }

    public void removeChannelCreatedObserver(SlackEventObserver<SlackChannelCreatedEvent> observer) {
        this.removeObserver(SlackEventType.CHANNEL_CREATED, observer);
    }

    public void removeChannelDeletedObserver(SlackEventObserver<SlackChannelDeletedEvent> observer) {
        this.removeObserver(SlackEventType.CHANNEL_DELETED, observer);
    }

    public void removeChannelJoinedObserver(SlackEventObserver<SlackChannelJoinedEvent> observer) {
        this.removeObserver(SlackEventType.CHANNEL_JOINED, observer);
    }

    public void removeChannelLeftObserver(SlackEventObserver<SlackChannelLeftEvent> observer) {
        this.removeObserver(SlackEventType.CHANNEL_LEFT, observer);
    }

    public void removeChannelRenameObservers(SlackEventObserver<SlackChannelRenameEvent> observer) {
        this.removeObserver(SlackEventType.CHANNEL_RENAME, observer);
    }

    public void removeErrorObserver(SlackEventObserver<SlackErrorEvent> observer) {
        this.removeObserver(SlackEventType.ERROR, observer);
    }

    public void removeGroupJoinedObserver(SlackEventObserver<SlackChannelJoinedEvent> observer) {
        this.removeObserver(SlackEventType.GROUP_JOINED, observer);
    }

    public void removeGroupLeftObserver(SlackEventObserver<SlackChannelLeftEvent> observer) {
        this.removeObserver(SlackEventType.GROUP_LEFT, observer);
    }

    public void removeGrouplJoinedObserver(SlackEventObserver<SlackChannelJoinedEvent> observer) {
        this.removeObserver(SlackEventType.GROUP_JOINED, observer);
    }

    public void removeGroupRenameObservers(SlackEventObserver<SlackChannelRenameEvent> observer) {
        this.removeObserver(SlackEventType.GROUP_RENAME, observer);
    }

    public void removeHelloObservers(SlackEventObserver<SlackHelloEvent> observer) {
        this.removeObserver(SlackEventType.HELLO, observer);
    }

    public void removeMessageChangedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.removeObserver(SlackMessageEventType.MESSAGE_CHANGED, observer);
    }

    public void removeMessageDeletedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.removeObserver(SlackMessageEventType.MESSAGE_DELETED, observer);
    }

    public void removeMessagePostedObserver(SlackEventObserver<SlackMessageEvent> observer) {
        this.removeObserver(SlackEventType.MESSAGE, observer);
    }

    public void removePongObserver(SlackEventObserver<SlackPongEvent> observer) {
        this.removeObserver(SlackEventType.PONG, observer);
    }

    public void removeReplyToObserver(SlackEventObserver<SlackReplyToEvent> observer) {
        this.removeObserver(SlackEventType.REPLY_TO, observer);
    }

    public void removeUnknownMessageObserver(SlackEventObserver<SlackUnknownEvent> observer) {
        this.removeObserver(SlackMessageEventType.UNKNOWN, observer);
    }

    public void removeUnknownObserver(SlackEventObserver<SlackUnknownEvent> observer) {
        this.removeObserver(SlackEventType.UNKNOWN, observer);
    }

    public void removeUserChangeObserver(SlackEventObserver<SlackUserChangeEvent> observer) {
        this.removeObserver(SlackEventType.USER_CHANGE, observer);
    }

    public void removeUserTypingObserver(SlackEventObserver<SlackUserTypingEvent> observer) {
        this.removeObserver(SlackEventType.USER_TYPING, observer);
    }

    <T, E extends SlackEvent, L extends SlackEventObserver<E>> Collection<L> findObservers(T eventType) {
        Collection<Object> collection = Collections.emptyList();
        if (this.observers.containsKey(eventType)) {
            collection = this.observers.get(eventType);
        } else if (this.messageObservers.containsKey(eventType)) {
            collection = this.messageObservers.get(eventType);
        }
        return new ArrayList(collection);
    }

    <E> boolean isObserverRegistered(E eventType, SlackEventObserver<?> observer) {
        if (this.observers.containsKey(eventType)) {
            return this.observers.get(eventType).contains(observer);
        }
        if (this.messageObservers.containsKey(eventType)) {
            return this.messageObservers.get(eventType).contains(observer);
        }
        return false;
    }

    private <E, T extends SlackEvent> void addObserver(SlackEventType eventType, SlackEventObserver<T> observer) {
        this.observers.computeIfAbsent(eventType, k -> new Vector()).add(observer);
    }

    private <T extends SlackEvent> void addObserver(SlackMessageEventType eventType, SlackEventObserver<T> observer) {
        this.messageObservers.computeIfAbsent(eventType, k -> new Vector()).add(observer);
    }

    private <E> void removeObserver(E eventType, SlackEventObserver<?> observer) {
        if (this.observers.containsKey(eventType)) {
            this.observers.get(eventType).remove(observer);
        }
        if (this.messageObservers.containsKey(eventType)) {
            this.messageObservers.get(eventType).remove(observer);
        }
    }
}

