/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client.rtm;

import io.dangernoodle.slack.client.SlackClient;
import io.dangernoodle.slack.client.SlackClientSettings;
import io.dangernoodle.slack.client.SlackJsonTransformer;
import io.dangernoodle.slack.events.SlackEvent;
import io.dangernoodle.slack.events.SlackEventType;
import io.dangernoodle.slack.events.SlackHelloEvent;
import io.dangernoodle.slack.events.SlackMessageEvent;
import io.dangernoodle.slack.events.SlackMessageEventType;
import io.dangernoodle.slack.events.SlackPongEvent;
import io.dangernoodle.slack.events.SlackReplyToEvent;
import io.dangernoodle.slack.events.SlackUnknownEvent;
import io.dangernoodle.slack.events.channel.SlackChannelCreatedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelDeletedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelJoinedEvent;
import io.dangernoodle.slack.events.channel.SlackChannelLeftEvent;
import io.dangernoodle.slack.events.channel.SlackChannelRenameEvent;
import io.dangernoodle.slack.events.user.SlackPresenceChangeEvent;
import io.dangernoodle.slack.events.user.SlackUserChangeEvent;
import io.dangernoodle.slack.events.user.SlackUserTypingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWebSocketAssistant {
    private static final Logger logger = LoggerFactory.getLogger(SlackWebSocketAssistant.class);
    private final SlackClient client;
    private final SlackClientSettings settings;
    private final SlackJsonTransformer transformer;

    public SlackWebSocketAssistant(SlackClient client, SlackJsonTransformer transformer, SlackClientSettings settings) {
        this.client = client;
        this.transformer = transformer;
        this.settings = settings;
    }

    public void handleEvent(String message) {
        SlackJsonTransformer.SlackJsonObject object;
        String type;
        if (logger.isTraceEnabled()) {
            logger.trace("incoming event:\n{}", (Object)this.transformer.prettyPrint(message));
        }
        if ((type = (object = this.transformer.deserialize(message)).getType()) != null) {
            String subType = object.getSubType();
            SlackEventType eventType = SlackEventType.toEventType(object.getType());
            this.dispatchEvent(eventType, subType, object);
        } else if (object.isReplyTo()) {
            this.dispatch(SlackEventType.REPLY_TO, object, SlackReplyToEvent.class);
        } else {
            logger.warn("unknown incoming slack message:\n{}", (Object)this.transformer.prettyPrint(message));
        }
    }

    public String serialize(Object object) {
        return this.transformer.serialize(object);
    }

    private <E, T extends SlackEvent> void dispatch(E eventType, SlackJsonTransformer.SlackJsonObject object, Class<T> clazz) {
        SlackEvent event = (SlackEvent)this.transformer.deserialize(object, clazz);
        logger.debug("dispatching event type [{}] - event: {}", (Object)event.getType().toType(), (Object)event);
        this.client.getObserverRegistry().findObservers(eventType).forEach(observer -> observer.onEvent(event, this.client));
    }

    private void dispatch(SlackEventType eventType, String subType, SlackJsonTransformer.SlackJsonObject object) {
        if (this.filterSelfUserMessages(object)) {
            if (logger.isTraceEnabled()) {
                logger.trace("filtered 'self' message {}", (Object)this.transformer.prettyPrint(object.getRawJson()));
            }
        } else if (this.dispatchAsMessageSubtype(eventType, subType)) {
            SlackMessageEventType messageEventType = SlackMessageEventType.toEventType(subType);
            if (messageEventType == SlackMessageEventType.UNKNOWN) {
                this.logUnknownEvent(object, true);
                this.dispatch(SlackMessageEventType.UNKNOWN, object, SlackUnknownEvent.class);
            } else {
                this.dispatch(SlackMessageEventType.toEventType(subType), object, SlackMessageEvent.class);
            }
        } else {
            this.dispatch(eventType, object, SlackMessageEvent.class);
        }
    }

    private boolean dispatchAsMessageSubtype(SlackEventType eventType, String subType) {
        return eventType == SlackEventType.MESSAGE && subType != null && this.settings.dispatchMessageSubtypes();
    }

    private void dispatchEvent(SlackEventType eventType, String subType, SlackJsonTransformer.SlackJsonObject object) {
        switch (eventType) {
            case CHANNEL_CREATED: {
                this.dispatch(eventType, object, SlackChannelCreatedEvent.class);
                break;
            }
            case CHANNEL_DELETED: {
                this.dispatch(eventType, object, SlackChannelDeletedEvent.class);
                break;
            }
            case CHANNEL_JOINED: {
                this.dispatch(eventType, object, SlackChannelJoinedEvent.class);
                break;
            }
            case CHANNEL_LEFT: {
                this.dispatch(eventType, object, SlackChannelLeftEvent.class);
                break;
            }
            case CHANNEL_RENAME: {
                this.dispatch(eventType, object, SlackChannelRenameEvent.class);
                break;
            }
            case GROUP_JOINED: {
                this.dispatch(eventType, object, SlackChannelJoinedEvent.class);
                break;
            }
            case GROUP_LEFT: {
                this.dispatch(eventType, object, SlackChannelLeftEvent.class);
                break;
            }
            case GROUP_RENAME: {
                this.dispatch(eventType, object, SlackChannelRenameEvent.class);
                break;
            }
            case HELLO: {
                this.dispatch(eventType, object, SlackHelloEvent.class);
                break;
            }
            case MESSAGE: {
                this.dispatch(eventType, subType, object);
                break;
            }
            case PRESENCE_CHANGE: {
                this.dispatch(eventType, object, SlackPresenceChangeEvent.class);
                break;
            }
            case PONG: {
                this.dispatch(eventType, object, SlackPongEvent.class);
                break;
            }
            case RECONNECT_URL: {
                break;
            }
            case USER_CHANGE: {
                this.dispatch(eventType, object, SlackUserChangeEvent.class);
                break;
            }
            case USER_TYPING: {
                this.dispatch(eventType, object, SlackUserTypingEvent.class);
                break;
            }
            default: {
                this.logUnknownEvent(object, false);
                this.dispatch(eventType, object, SlackUnknownEvent.class);
            }
        }
    }

    private boolean filterSelfUserMessages(SlackJsonTransformer.SlackJsonObject object) {
        return this.settings.filterSelfMessages() && this.client.getSession().getSelfUser().getId().value().equals(object.getUser());
    }

    private void logUnknownEvent(SlackJsonTransformer.SlackJsonObject object, boolean message) {
        if (logger.isDebugEnabled()) {
            logger.debug("unhandled {}event occurred: {}", (Object)(message ? "message " : ""), (Object)this.transformer.prettyPrint(object.getRawJson()));
        }
    }
}

