/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.client.web;

import io.dangernoodle.slack.client.SlackClientSettings;
import io.dangernoodle.slack.client.SlackHttpDelegate;
import io.dangernoodle.slack.client.SlackJsonTransformer;
import io.dangernoodle.slack.client.web.SlackWebMethods;
import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.api.SlackFileUpload;
import io.dangernoodle.slack.objects.api.SlackPostMessage;
import io.dangernoodle.slack.objects.api.SlackStartRtmResponse;
import io.dangernoodle.slack.objects.api.SlackWebResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWebClient {
    private static final String ATTACHMENTS = "attachments";
    private static final Logger logger = LoggerFactory.getLogger(SlackWebClient.class);
    private final SlackHttpDelegate httpDelegate;
    private final SlackJsonTransformer jsonTransformer;
    private final SlackClientSettings settings;

    public SlackWebClient(SlackClientSettings settings, SlackHttpDelegate httpDelegate, SlackJsonTransformer jsonTransformer) {
        this.settings = settings;
        this.httpDelegate = httpDelegate;
        this.jsonTransformer = jsonTransformer;
    }

    public SlackStartRtmResponse initiateRtmConnection() throws IOException {
        String response = this.httpDelegate.get(SlackWebMethods.rtmStart.toUrl() + "?token=" + this.settings.getAuthToken());
        this.logRequest(SlackWebMethods.rtmStart, null, response);
        return this.jsonTransformer.deserialize(response, SlackStartRtmResponse.class);
    }

    public SlackWebResponse send(SlackMessageable.Id id, SlackPostMessage.Builder builder) throws IOException {
        Map<String, Object> serialized = this.serialize(builder.build(this.settings.getAuthToken(), id));
        serialized.put(ATTACHMENTS, this.jsonTransformer.serialize(serialized.get(ATTACHMENTS)));
        return this.post(SlackWebMethods.chatPostMessage.toUrl(), serialized, SlackWebResponse.class);
    }

    public SlackWebResponse upload(SlackFileUpload.Builder builder, SlackMessageable.Id ... ids) throws IOException {
        SlackFileUpload upload = builder.build(this.settings.getAuthToken(), ids);
        Map<String, Object> serialized = this.serialize(upload);
        String response = this.httpDelegate.upload(SlackWebMethods.filesUpload.toUrl(), upload.getFile(), upload.getFilename(), serialized);
        this.logRequest(SlackWebMethods.filesUpload, serialized, response);
        return this.jsonTransformer.deserialize(response, SlackWebResponse.class);
    }

    private void logRequest(SlackWebMethods command, Map<String, Object> serialized, String response) {
        this.logRequest(command.toUrl(), serialized, response);
    }

    private void logRequest(String command, Map<String, Object> serialized, String response) {
        if (logger.isTraceEnabled()) {
            logger.trace("url: {} - body: {}", (Object)command, serialized);
            logger.trace("response: {}", (Object)this.jsonTransformer.prettyPrint(response));
        }
    }

    private <T> T post(String url, Map<String, Object> serialized, Class<T> clazz) throws IOException {
        String response = this.httpDelegate.post(url, serialized);
        this.logRequest(url, serialized, response);
        return this.jsonTransformer.deserialize(response, clazz);
    }

    private Map<String, Object> serialize(Object object) {
        return this.jsonTransformer.deserialize(this.jsonTransformer.serialize(object), Map.class);
    }
}

