/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.events;

public enum SlackEventType {
    ACCOUNTS_CHANGED,
    BOT_ADDED,
    BOT_CHANGED,
    CHANNEL_ARCHIVE,
    CHANNEL_CREATED,
    CHANNEL_DELETED,
    CHANNEL_HISTORY_CHANGED,
    CHANNEL_JOINED,
    CHANNEL_LEFT,
    CHANNEL_MARKED,
    CHANNEL_RENAME,
    CHANNEL_UNARCHIVE,
    COMMANDS_CHANGED,
    DND_UPDATED,
    DND_UPDATED_USER,
    EMAIL_DOMAIN_CHANGED,
    EMOJI_CHANGED,
    ERROR,
    FILE_CHANGE,
    FILE_COMMENT_ADDED,
    FILE_COMMENT_DELETED,
    FILE_COMMENT_EDITED,
    FILE_CREATED,
    FILE_DELETED,
    FILE_PUBLIC,
    FILE_SHARED,
    FILE_UNSHARED,
    GROUP_ARCHIVE,
    GROUP_CLOSE,
    GROUP_HISTORY_CHANGED,
    GROUP_JOINED,
    GROUP_LEFT,
    GROUP_MARKED,
    GROUP_OPEN,
    GROUP_RENAME,
    GROUP_UNARCHIVE,
    HELLO,
    IM_CLOSE,
    IM_CREATED,
    IM_HISTORY_CHANGED,
    IM_MARKED,
    IM_OPEN,
    MANUAL_PRESENCE_CHANGE,
    MESSAGE,
    PIN_ADDED,
    PIN_REMOVED,
    PONG,
    PREF_CHANGE,
    PRESENCE_CHANGE,
    REACTION_ADDED,
    REACTION_REMOVED,
    RECONNECT_URL,
    REPLY_TO,
    STAR_ADDED,
    STAR_REMOVED,
    SUBTEAM_CREATED,
    SUBTEAM_SELF_ADDED,
    SUBTEAM_SELF_REMOVED,
    SUBTEAM_UPDATED,
    TEAM_DOMAIN_CHANGE,
    TEAM_JOIN,
    TEAM_MIGRATION_STARTED,
    TEAM_PLAN_CHANGE,
    TEAM_PREF_CHANGE,
    TEAM_PROFILE_CHANGE,
    TEAM_PROFILE_DELETE,
    TEAM_PROFILE_REORDER,
    TEAM_RENAME,
    USER_CHANGE,
    USER_TYPING,
    UNKNOWN;


    public static SlackEventType toEventType(String type) {
        try {
            return Enum.valueOf(SlackEventType.class, type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    public String toType() {
        return this.toString().toLowerCase();
    }
}

