/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.objects.api;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SlackAttachment {
    static final String SHORT = "short";
    static final String TITLE = "title";
    static final String VALUE = "value";
    private String authorIcon;
    private String authorLink;
    private String authorName;
    private String color;
    private String fallback;
    private List<Map<String, Object>> fields;
    private String footer;
    private String footerIcon;
    private String imageUrl;
    private String[] mrkdwnIn;
    private String pretext;
    private String text;
    private String thumbUrl;
    private String title;
    private String titleLink;
    private Long ts;

    static /* synthetic */ String[] access$902(SlackAttachment x0, String[] x1) {
        x0.mrkdwnIn = x1;
        return x1;
    }

    public static enum Markdown {
        fields,
        pretext,
        text;

    }

    public static enum Color {
        danger,
        good,
        warning;

    }

    public static class Builder {
        private SlackAttachment attachment = new SlackAttachment();

        public Builder addField(String title, String value, boolean isShort) {
            if (this.attachment.fields == null) {
                this.attachment.fields = new ArrayList();
            }
            this.attachment.fields.add(Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>(SlackAttachment.TITLE, title), new AbstractMap.SimpleEntry<String, String>(SlackAttachment.VALUE, value), new AbstractMap.SimpleEntry<String, Boolean>(SlackAttachment.SHORT, isShort)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Serializable)e.getValue()))));
            return this;
        }

        public Builder authorIcon(String authorIcon) {
            this.attachment.authorIcon = authorIcon;
            return this;
        }

        public Builder authorLink(String authorLink) {
            this.attachment.authorLink = authorLink;
            return this;
        }

        public Builder authorName(String authorName) {
            this.attachment.authorName = authorName;
            return this;
        }

        public SlackAttachment build() {
            SlackAttachment tmp = this.attachment;
            this.attachment = new SlackAttachment();
            return tmp;
        }

        public Builder color(Color color) {
            this.attachment.color = color.toString();
            return this;
        }

        public Builder color(String color) throws IllegalArgumentException {
            if (!color.startsWith("#")) {
                throw new IllegalArgumentException("color must be hex code");
            }
            this.attachment.color = color;
            return this;
        }

        public Builder fallback(String fallback) {
            this.attachment.fallback = fallback;
            return this;
        }

        public Builder fallback(String format, Object ... args) {
            return this.fallback(String.format(format, args));
        }

        public Builder footer(String footer) {
            this.attachment.footer = footer;
            return this;
        }

        public Builder footerIcon(String footerIcon) {
            this.attachment.footerIcon = footerIcon;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.attachment.imageUrl = imageUrl;
            return this;
        }

        public Builder markdown(Markdown ... markdown) {
            SlackAttachment.access$902(this.attachment, (String[])Stream.of(markdown).map(Enum::toString).toArray(String[]::new));
            return this;
        }

        public Builder pretext(String pretext) {
            this.attachment.pretext = pretext;
            return this;
        }

        public Builder pretext(String format, Object ... args) {
            return this.pretext(String.format(format, args));
        }

        public Builder text(String text) {
            this.attachment.text = text;
            return this;
        }

        public Builder text(String format, Object ... args) {
            return this.text(String.format(format, args));
        }

        public Builder thumbUrl(String thumbUrl) {
            this.attachment.thumbUrl = thumbUrl;
            return this;
        }

        public Builder timestamp(Long timestamp) {
            this.attachment.ts = timestamp;
            return this;
        }

        public Builder title(String title) {
            this.attachment.title = title;
            return this;
        }

        public Builder title(String format, Object ... args) {
            return this.title(String.format(format, args));
        }

        public Builder titleLink(String titleLink) {
            this.attachment.titleLink = titleLink;
            return this;
        }
    }
}

