/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.objects.api;

import io.dangernoodle.slack.objects.SlackMessageable;
import java.io.File;
import java.util.stream.Stream;

public class SlackFileUpload {
    private String channels;
    private transient File file;
    private transient String filename;
    private String filetype;
    private String initialComment;
    private String title;
    private String token;

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename == null ? this.file.getName() : this.filename;
    }

    public static class Builder {
        private SlackFileUpload upload = new SlackFileUpload();

        public Builder(File file) {
            this.upload.file = file;
        }

        public SlackFileUpload build(String authToken, SlackMessageable.Id ... ids) {
            SlackFileUpload tmp = this.upload;
            this.upload = new SlackFileUpload();
            tmp.token = authToken;
            tmp.channels = String.join((CharSequence)",", (CharSequence[])Stream.of(ids).map(SlackMessageable.Id::value).toArray(String[]::new));
            return tmp;
        }

        public Builder filename(String filename) {
            this.upload.filename = filename;
            return this;
        }

        public Builder filetype(String filetype) {
            this.upload.filetype = filetype;
            return this;
        }

        public Builder initialComment(String initialComment) {
            this.upload.initialComment = initialComment;
            return this;
        }

        public Builder title(String title) {
            this.upload.title = title;
            return this;
        }
    }
}

