/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.objects.api;

import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.api.SlackAttachment;
import java.util.ArrayList;
import java.util.List;

public class SlackPostMessage {
    private Boolean asUser = true;
    private List<SlackAttachment> attachments;
    private String channel;
    private String iconEmoji;
    private String iconUrl;
    private Integer linkNames;
    private String parse;
    private String text;
    private String token;
    private Boolean unfurlLinks;
    private Boolean unfurlMedia;
    private String username;

    public static enum Parse {
        dftl,
        full,
        none;

    }

    public static class Builder {
        private SlackPostMessage message = new SlackPostMessage();

        public Builder(SlackAttachment.Builder builder) {
            this.attachment(builder);
        }

        public Builder(String text) {
            this.text(text);
        }

        public Builder asUser(boolean asUser) {
            this.message.asUser = asUser;
            return this;
        }

        public Builder attachment(SlackAttachment.Builder builder) {
            if (this.message.attachments == null) {
                this.message.attachments = new ArrayList();
            }
            this.message.attachments.add(builder.build());
            return this;
        }

        public SlackPostMessage build(String authToken, SlackMessageable.Id id) {
            this.message.token = authToken;
            this.message.channel = id.value();
            return this.message;
        }

        public Builder iconEmoji(String iconEmoji) {
            this.message.iconEmoji = iconEmoji;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.message.iconUrl = iconUrl;
            return this;
        }

        public Builder linkify(boolean linkify) {
            this.message.linkNames = linkify ? 1 : 0;
            return this;
        }

        public Builder parse(Parse parse) {
            this.message.parse = parse == Parse.dftl ? null : parse.toString();
            return this;
        }

        public Builder text(String text) {
            this.message.text = text;
            return this;
        }

        public Builder text(String format, Object ... args) {
            return this.text(String.format(format, args));
        }

        public Builder unfurlLinks(boolean unfurlLinks) {
            this.message.unfurlLinks = unfurlLinks;
            return this;
        }

        public Builder unfurlMedia(boolean unfurlMedia) {
            this.message.unfurlMedia = unfurlMedia;
            return this;
        }

        public Builder username(String username) {
            this.message.username = username;
            this.message.asUser = false;
            return this;
        }
    }
}

