/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.objects.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SlackWebResponse {
    private final String rawResponse;
    private final Map<String, Object> response;

    public SlackWebResponse(Map<String, Object> response, String rawResponse) {
        this.response = response;
        this.rawResponse = rawResponse;
    }

    public String getError() {
        return this.get("error").orElse(null);
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public Map<String, Object> getResponse() {
        return new HashMap<String, Object>(this.response);
    }

    public Collection<String> getWarnings() {
        return this.get("warning").map(this::split).orElse(Collections.emptyList());
    }

    public boolean isOk() {
        return this.get("ok").map(Boolean::valueOf).orElse(false);
    }

    private Optional<String> get(String key) {
        return this.response.containsKey(key) ? Optional.of(this.response.get(key).toString()) : Optional.empty();
    }

    private Collection<String> split(Object toSplit) {
        return Arrays.asList(toSplit.toString().split(","));
    }
}

