/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.dangernoodle.slack.client.SlackJsonTransformer;
import io.dangernoodle.slack.events.SlackEventType;
import io.dangernoodle.slack.events.SlackMessageEvent;
import io.dangernoodle.slack.events.SlackMessageEventType;
import io.dangernoodle.slack.events.SlackPongEvent;
import io.dangernoodle.slack.events.SlackUnknownEvent;
import io.dangernoodle.slack.objects.SlackIntegration;
import io.dangernoodle.slack.objects.SlackMessage;
import io.dangernoodle.slack.objects.SlackMessageable;
import io.dangernoodle.slack.objects.SlackTeam;
import io.dangernoodle.slack.objects.SlackUser;
import io.dangernoodle.slack.objects.api.SlackWebResponse;
import java.lang.reflect.Type;
import java.util.Map;

public class GsonTransformer
implements SlackJsonTransformer {
    private static final Type PONG_MAP_TYPE_TOKEN = GsonTransformer.createPongTypeToken();
    private final Gson gson;
    private final JsonParser jsonParser;
    private final Gson prettyPrinter;

    public GsonTransformer() {
        GsonBuilder builder = this.createGsonBuilder();
        this.gson = builder.create();
        this.jsonParser = new JsonParser();
        this.prettyPrinter = builder.setPrettyPrinting().create();
    }

    @Override
    public <T> T deserialize(SlackJsonTransformer.SlackJsonObject object, Class<T> clazz) {
        return (T)this.gson.fromJson((JsonElement)((GsonJsonObject)object).jsonObject, clazz);
    }

    @Override
    public SlackJsonTransformer.SlackJsonObject deserialize(String json) {
        return new GsonJsonObject(this.jsonParser.parse(json).getAsJsonObject());
    }

    @Override
    public <T> T deserialize(String json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    @Override
    public String prettyPrint(String json) {
        return this.prettyPrinter.toJson((JsonElement)this.jsonParser.parse(json).getAsJsonObject());
    }

    @Override
    public String serialize(Object object) {
        return this.gson.toJson(object);
    }

    private GsonBuilder createGsonBuilder() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(SlackEventType.class, this.deserializeEventType()).registerTypeAdapter(SlackMessageEvent.class, this.deserializeMessageEvent()).registerTypeAdapter(SlackIntegration.Id.class, this.deserializeIntegrationId()).registerTypeAdapter(SlackMessageable.Id.class, this.deserializeMessageableId()).registerTypeAdapter(SlackPongEvent.class, this.deserializePong()).registerTypeAdapter(SlackTeam.Id.class, this.deserializeTeamId()).registerTypeAdapter(SlackUnknownEvent.class, this.deserializeUnknownEvent()).registerTypeAdapter(SlackUser.Id.class, this.deserializeUserId()).registerTypeAdapter(SlackWebResponse.class, this.deserializeWebResponse());
    }

    private JsonDeserializer<SlackEventType> deserializeEventType() {
        return (json, typeOfT, context) -> SlackEventType.toEventType(json.getAsString());
    }

    private JsonDeserializer<SlackIntegration.Id> deserializeIntegrationId() {
        return (json, typeOfT, context) -> new SlackIntegration.Id(json.getAsString());
    }

    private JsonDeserializer<SlackMessageable.Id> deserializeMessageableId() {
        return (json, typeOfT, context) -> new SlackMessageable.Id(json.getAsString());
    }

    private JsonDeserializer<SlackMessageEvent> deserializeMessageEvent() {
        return (json, typeOfT, context) -> {
            JsonElement jsonElement = json.getAsJsonObject().get("subtype");
            SlackMessage message = (SlackMessage)context.deserialize(json, SlackMessage.class);
            SlackMessageEventType subType = jsonElement == null ? null : this.toSubtype(jsonElement.getAsString());
            return new SlackMessageEvent(message, subType);
        };
    }

    private JsonDeserializer<SlackPongEvent> deserializePong() {
        return (json, typeOfT, context) -> {
            Map map = (Map)context.deserialize(json, PONG_MAP_TYPE_TOKEN);
            map.remove("type");
            return new SlackPongEvent(this.toLong((String)map.remove("reply_to")), this.toLong((String)map.remove("time")), map);
        };
    }

    private JsonDeserializer<SlackTeam.Id> deserializeTeamId() {
        return (json, typeOfT, context) -> new SlackTeam.Id(json.getAsString());
    }

    private JsonDeserializer<SlackUnknownEvent> deserializeUnknownEvent() {
        return (json, typeOfT, context) -> new SlackUnknownEvent((Map)context.deserialize(json, Map.class), json.toString());
    }

    private JsonDeserializer<SlackUser.Id> deserializeUserId() {
        return (json, typeOfT, context) -> new SlackUser.Id(json.getAsString());
    }

    private JsonDeserializer<SlackWebResponse> deserializeWebResponse() {
        return (json, typeOfT, context) -> new SlackWebResponse((Map)context.deserialize(json, Map.class), json.toString());
    }

    private long toLong(String value) {
        return Long.valueOf(value);
    }

    private SlackMessageEventType toSubtype(String subtype) {
        return SlackMessageEventType.toEventType(subtype);
    }

    private static Type createPongTypeToken() {
        return new TypeToken<Map<String, String>>(){}.getType();
    }

    public static class GsonJsonObject
    implements SlackJsonTransformer.SlackJsonObject {
        private final JsonObject jsonObject;

        public GsonJsonObject(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public String getRawJson() {
            return this.jsonObject.toString();
        }

        @Override
        public String getSubType() {
            return this.get("subtype");
        }

        @Override
        public String getType() {
            return this.get("type");
        }

        @Override
        public String getUser() {
            return this.get("user");
        }

        @Override
        public boolean isReplyTo() {
            return this.jsonObject.has("ok") && this.jsonObject.has("reply_to");
        }

        private String get(String key) {
            return this.jsonObject.has(key) ? this.jsonObject.get(key).getAsString() : null;
        }
    }
}

