/*
 * Decompiled with CFR 0.152.
 */
package io.dangernoodle.slack.utils;

import io.dangernoodle.slack.client.SlackHttpDelegate;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpDelegate
implements SlackHttpDelegate {
    public static final MediaType MEDIA_TYPE_BINARY = MediaType.parse((String)"application/octet-stream");
    private final OkHttpClient httpClient = this.createOkHttpClient();

    @Override
    public String get(String url) throws IOException {
        return this.execute(this.createBuilder(url));
    }

    @Override
    public String post(String url, Map<String, Object> formData) throws IOException {
        FormBody.Builder builder = new FormBody.Builder();
        formData.forEach((k, v) -> builder.add(k, v.toString()));
        return this.execute(this.createBuilder(url).post((RequestBody)builder.build()));
    }

    @Override
    public String upload(String url, File file, String filename, Map<String, Object> formData) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        formData.forEach((k, v) -> builder.addFormDataPart(k, v.toString()));
        builder.addFormDataPart("file", filename, RequestBody.create((MediaType)MEDIA_TYPE_BINARY, (File)file));
        return this.execute(this.createBuilder(url).post((RequestBody)builder.build()));
    }

    OkHttpClient createOkHttpClient() {
        return new OkHttpClient.Builder().build();
    }

    private Request.Builder createBuilder(String url) {
        return new Request.Builder().url(url);
    }

    private String execute(Request.Builder builder) throws IOException {
        Response response = this.httpClient.newCall(builder.build()).execute();
        if (!response.isSuccessful()) {
            throw new SlackHttpDelegate.SlackHttpException(response.code(), response.message());
        }
        return response.body().string();
    }
}

