/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.contour;

import io.data2viz.contour.Contour;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\b\u001a5\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0015\u001a\u001f\u0010\u0016\u001a\u00020\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b\u001b\u001a\u001f\u0010\u001c\u001a\u00020\u00022\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0001\u00a2\u0006\u0002\u0010\u001e\u001a3\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010 \u001a!\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\"\u001a-\u0010#\u001a\u00020$2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010'\u001a5\u0010(\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0015\u001a\u001e\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002\"+\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00010\u00010\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u001e\u0010\u000b\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001e\u0010\u000e\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006-"}, d2={"cases", "", "", "getCases", "()[[[[Ljava/lang/Double;", "[[[[Ljava/lang/Double;", "end", "getEnd", "([[Ljava/lang/Double;)[Ljava/lang/Double;", "start", "getStart", "x", "getX", "([Ljava/lang/Double;)D", "y", "getY", "collinear", "", "a", "b", "c", "([Ljava/lang/Double;[Ljava/lang/Double;[Ljava/lang/Double;)Z", "contour", "Lio/data2viz/contour/Contour;", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "doubleArea", "ring", "([[Ljava/lang/Double;)D", "line", "([Ljava/lang/Double;[Ljava/lang/Double;)[[Ljava/lang/Double;", "pt", "(DD)[Ljava/lang/Double;", "ringContains", "", "", "point", "(Ljava/util/List;[Ljava/lang/Double;)I", "segmentContains", "within", "p", "q", "r", "d2v-contour-jvm"})
public final class ContourKt {
    @NotNull
    private static final Double[][][][] cases = new Double[][][][]{new Double[0][][], new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 1.5), ContourKt.pt(0.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.5, 1.0), ContourKt.pt(1.0, 1.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.5, 1.0), ContourKt.pt(0.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 0.5), ContourKt.pt(1.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 0.5), ContourKt.pt(0.5, 1.0)), ContourKt.line(ContourKt.pt(1.0, 1.5), ContourKt.pt(1.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 0.5), ContourKt.pt(1.0, 1.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 0.5), ContourKt.pt(0.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(0.5, 1.0), ContourKt.pt(1.0, 0.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 1.5), ContourKt.pt(1.0, 0.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(0.5, 1.0), ContourKt.pt(1.0, 1.5)), ContourKt.line(ContourKt.pt(1.5, 1.0), ContourKt.pt(1.0, 0.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.5, 1.0), ContourKt.pt(1.0, 0.5))}, new Double[][][]{ContourKt.line(ContourKt.pt(0.5, 1.0), ContourKt.pt(1.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(1.0, 1.5), ContourKt.pt(1.5, 1.0))}, new Double[][][]{ContourKt.line(ContourKt.pt(0.5, 1.0), ContourKt.pt(1.0, 1.5))}, new Double[0][][]};

    @NotNull
    public static final Contour contour(@NotNull Function1<? super Contour, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        Contour contour = new Contour();
        boolean bl = false;
        boolean bl2 = false;
        init.invoke((Object)contour);
        return contour;
    }

    @NotNull
    public static final Double[][][][] getCases() {
        return cases;
    }

    @NotNull
    public static final Double[][] line(@NotNull Double[] start, @NotNull Double[] end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        return new Double[][]{start, end};
    }

    @NotNull
    public static final Double[] pt(double x, double y) {
        return new Double[]{x, y};
    }

    public static final double doubleArea(@NotNull Double[][] ring) {
        Intrinsics.checkParameterIsNotNull((Object)ring, (String)"ring");
        int i = 0;
        int n = ((Object[])ring).length;
        double area = ring[n - 1][1] * ring[0][0] - ring[n - 1][0] * ring[0][1];
        while (++i < n) {
            area += ring[i - 1][1] * ring[i][0] - ring[i - 1][0] * ring[i][1];
        }
        return area;
    }

    public static final int ringContains(@NotNull List<Double[]> ring, @NotNull Double[] point) {
        Intrinsics.checkParameterIsNotNull(ring, (String)"ring");
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        double x = point[0];
        double y = point[1];
        int contains = -1;
        int n = ring.size();
        int j = n - 1;
        int i = 0;
        do {
            Double[] pi = ring.get(i);
            double xi = pi[0];
            double yi = pi[1];
            Double[] pj = ring.get(j);
            double xj = pj[0];
            double yj = pj[1];
            if (ContourKt.segmentContains(pi, pj, point)) {
                return 0;
            }
            if (yi > y != yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi) {
                contains = -contains;
            }
            j = i++;
        } while (i < n);
        return contains;
    }

    public static final boolean segmentContains(@NotNull Double[] start, @NotNull Double[] end, @NotNull Double[] point) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        int i = start[0].doubleValue() == end[0].doubleValue() ? 1 : 0;
        return ContourKt.collinear(start, end, point) && ContourKt.within(start[i], point[i], end[i]);
    }

    public static final boolean within(double p, double q, double r) {
        double d;
        double d2 = q;
        return d2 >= p && d2 <= r || (d = q) >= r && d <= p;
    }

    public static final boolean collinear(@NotNull Double[] a, @NotNull Double[] b, @NotNull Double[] c) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return (b[0] - a[0]) * (c[1] - a[1]) == (c[0] - a[0]) * (b[1] - a[1]);
    }

    private static final double getX(@NotNull Double[] $this$x) {
        return $this$x[0];
    }

    private static final double getY(@NotNull Double[] $this$y) {
        return $this$y[1];
    }

    private static final Double[] getStart(@NotNull Double[][] $this$start) {
        return $this$start[0];
    }

    private static final Double[] getEnd(@NotNull Double[][] $this$end) {
        return $this$end[1];
    }

    public static final /* synthetic */ double access$getX$p(Double[] $this$access_u24x_u24p) {
        return ContourKt.getX($this$access_u24x_u24p);
    }

    public static final /* synthetic */ double access$getY$p(Double[] $this$access_u24y_u24p) {
        return ContourKt.getY($this$access_u24y_u24p);
    }

    public static final /* synthetic */ Double[] access$getStart$p(Double[][] $this$access_u24start_u24p) {
        return ContourKt.getStart($this$access_u24start_u24p);
    }

    public static final /* synthetic */ Double[] access$getEnd$p(Double[][] $this$access_u24end_u24p) {
        return ContourKt.getEnd($this$access_u24end_u24p);
    }
}

