/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a8\u0006\t"}, d2={"toExponential", "", "", "digits", "", "toFixed", "toPrecision", "toStringDigits", "radix", "d2v-format-jvm"})
public final class NumberManipulationsKt {
    @NotNull
    public static final String toStringDigits(double $receiver, int radix) {
        String string;
        if ($receiver > (double)Long.MAX_VALUE || $receiver < (double)Long.MIN_VALUE) {
            string = NumberManipulationsKt.toExponential($receiver);
        } else {
            long l = MathKt.roundToLong((double)$receiver);
            String string2 = Long.toString(l, CharsKt.checkRadix((int)radix));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        }
        return string;
    }

    @NotNull
    public static final String toFixed(double $receiver, int digits) {
        String string = new BigDecimal($receiver).setScale(digits, 4).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BigDecimal(this)\n       \u2026              .toString()");
        return string;
    }

    @NotNull
    public static final String toExponential(double $receiver, int digits) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        String string = "%." + digits + "e";
        Object[] objectArray = new Object[]{$receiver};
        String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"e+0", (String)"e+", (boolean)false, (int)4, null), (String)"e-0", (String)"e-", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toExponential(double $receiver) {
        int n;
        int n2;
        String string;
        int fractionalPartSize;
        block13: {
            String string2;
            String fracRemovedDecExpZeros;
            String integerPart;
            block12: {
                int exponentIndex;
                CharSequence $receiver$iv2;
                char it;
                int index$iv;
                int n3;
                block11: {
                    int n4;
                    int n5;
                    Object object;
                    String fractionalPart;
                    block10: {
                        BigDecimal preciseNum;
                        double d = Math.abs($receiver);
                        String string3 = String.valueOf(d);
                        BigDecimal bigDecimal = preciseNum = new BigDecimal(string3);
                        BigDecimal bigDecimal2 = BigDecimal.ONE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"BigDecimal.ONE");
                        BigDecimal bigDecimal3 = bigDecimal2;
                        BigDecimal bigDecimal4 = bigDecimal.remainder(bigDecimal3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal4, (String)"this.remainder(other)");
                        String string4 = bigDecimal4.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(preciseNum % BigDecimal.ONE).toString()");
                        fractionalPart = string4;
                        bigDecimal3 = preciseNum;
                        BigDecimal bigDecimal5 = BigDecimal.ONE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal5, (String)"BigDecimal.ONE");
                        object = bigDecimal5;
                        BigDecimal bigDecimal6 = bigDecimal3.divide((BigDecimal)object, RoundingMode.HALF_EVEN);
                        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal6, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
                        String string5 = bigDecimal6.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"preciseNum.div(BigDecimal.ONE).toString()");
                        integerPart = string5;
                        object = fractionalPart;
                        CharSequence $receiver$iv = fractionalPart;
                        int n6 = 0;
                        n3 = $receiver$iv.length();
                        while (n6 < n3) {
                            it = $receiver$iv.charAt(index$iv);
                            if (it == '.') {
                                n5 = index$iv;
                                break block10;
                            }
                            ++index$iv;
                        }
                        n5 = -1;
                    }
                    int $receiver$iv = n5 + 1;
                    index$iv = fractionalPart.length();
                    Object object2 = object;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = ((String)object2).substring($receiver$iv, index$iv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    fracRemovedDecExpZeros = string6;
                    $receiver$iv2 = fracRemovedDecExpZeros;
                    n3 = $receiver$iv2.length();
                    for (index$iv = 0; index$iv < n3; ++index$iv) {
                        it = $receiver$iv2.charAt(index$iv);
                        if (!(it == 'e' || it == 'E')) continue;
                        n4 = index$iv;
                        break block11;
                    }
                    n4 = exponentIndex = -1;
                }
                if (exponentIndex >= 0) {
                    $receiver$iv2 = fracRemovedDecExpZeros;
                    index$iv = 0;
                    CharSequence charSequence = $receiver$iv2;
                    if (charSequence == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = ((String)charSequence).substring(index$iv, exponentIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    fracRemovedDecExpZeros = string7;
                }
                $receiver$iv2 = fracRemovedDecExpZeros;
                n3 = $receiver$iv2.length();
                for (index$iv = 0; index$iv < n3; ++index$iv) {
                    it = ((String)$receiver$iv2).charAt(index$iv);
                    if (it == '0') continue;
                    CharSequence charSequence = $receiver$iv2;
                    String string8 = ((String)charSequence).substring(index$iv);
                    string2 = string8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    break block12;
                }
                string2 = "";
            }
            fracRemovedDecExpZeros = string2;
            fractionalPartSize = fracRemovedDecExpZeros.length();
            string = integerPart;
            n2 = 0;
            CharSequence $receiver$iv = integerPart;
            int $i$f$dropWhile = 0;
            int n7 = $receiver$iv.length();
            while ($i$f$dropWhile < n7) {
                void index$iv;
                char it = $receiver$iv.charAt((int)index$iv);
                if (it == '.') {
                    n = index$iv;
                    break block13;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n8 = n;
        String string9 = string;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.substring(n2, n8);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        int integerPartSize = string10.length();
        String pattern = "%" + integerPartSize + "." + (integerPartSize + fractionalPartSize - 1) + "e";
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        Object[] objectArray = new Object[]{$receiver};
        String string11 = String.format(locale2, pattern, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(locale, format, *args)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string11, (String)"e+0", (String)"e+", (boolean)false, (int)4, null), (String)"e-0", (String)"e-", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toPrecision(double $receiver, int digits) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        String string = "%." + digits + "g";
        Object[] objectArray = new Object[]{$receiver};
        String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"e+0", (String)"e+", (boolean)false, (int)4, null), (String)"e-0", (String)"e-", (boolean)false, (int)4, null);
    }
}

