/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hexbin;

import io.data2viz.geom.Extent;
import io.data2viz.geom.Path;
import io.data2viz.geom.Point;
import io.data2viz.hexbin.Bin;
import io.data2viz.hexbin.HexbinGenerator;
import io.data2viz.hexbin.HexbinKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0+J'\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u00101J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0!2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u001d\u00102\u001a\b\u0012\u0004\u0012\u0002030+2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0086\u0002J\u000e\u00104\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012Re\u0010\u0019\u001aM\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b( \u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0!\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00040\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&Re\u0010'\u001aM\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b( \u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001b0!\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00040\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&\u00a8\u00065"}, d2={"Lio/data2viz/hexbin/HexbinGenerator;", "", "()V", "_radius", "", "dx", "dy", "extent", "Lio/data2viz/geom/Extent;", "getExtent", "()Lio/data2viz/geom/Extent;", "setExtent", "(Lio/data2viz/geom/Extent;)V", "value", "height", "getHeight", "()D", "setHeight", "(D)V", "radius", "getRadius", "setRadius", "width", "getWidth", "setWidth", "x", "Lkotlin/Function3;", "Lio/data2viz/geom/Point;", "Lkotlin/ParameterName;", "name", "point", "", "index", "", "points", "getX", "()Lkotlin/jvm/functions/Function3;", "setX", "(Lkotlin/jvm/functions/Function3;)V", "y", "getY", "setY", "centers", "", "hexagon", "", "path", "Lio/data2viz/geom/Path;", "origin", "(Lio/data2viz/geom/Path;Lio/data2viz/geom/Point;Ljava/lang/Double;)V", "invoke", "Lio/data2viz/hexbin/Bin;", "mesh", "d2v-hexbin-jvm"})
public final class HexbinGenerator {
    @NotNull
    private Function3<? super Point, ? super Integer, ? super List<Point>, Double> x = x.1.INSTANCE;
    @NotNull
    private Function3<? super Point, ? super Integer, ? super List<Point>, Double> y = y.1.INSTANCE;
    @NotNull
    private Extent extent = new Extent(0.0, 0.0, 1.0, 1.0);
    private double dx;
    private double dy;
    private double _radius;

    @NotNull
    public final Function3<Point, Integer, List<Point>, Double> getX() {
        return this.x;
    }

    public final void setX(@NotNull Function3<? super Point, ? super Integer, ? super List<Point>, Double> function3) {
        Intrinsics.checkParameterIsNotNull(function3, (String)"<set-?>");
        this.x = function3;
    }

    @NotNull
    public final Function3<Point, Integer, List<Point>, Double> getY() {
        return this.y;
    }

    public final void setY(@NotNull Function3<? super Point, ? super Integer, ? super List<Point>, Double> function3) {
        Intrinsics.checkParameterIsNotNull(function3, (String)"<set-?>");
        this.y = function3;
    }

    @NotNull
    public final Extent getExtent() {
        return this.extent;
    }

    public final void setExtent(@NotNull Extent extent) {
        Intrinsics.checkParameterIsNotNull((Object)extent, (String)"<set-?>");
        this.extent = extent;
    }

    public final double getWidth() {
        return this.extent.getX1() - this.extent.getX0();
    }

    public final void setWidth(double value) {
        this.extent.setX0(0.0);
        this.extent.setX1(value);
    }

    public final double getHeight() {
        return this.extent.getY1() - this.extent.getY0();
    }

    public final void setHeight(double value) {
        this.extent.setY0(0.0);
        this.extent.setY1(value);
    }

    public final double getRadius() {
        return this._radius;
    }

    public final void setRadius(double value) {
        this._radius = value;
        double d = 1.0471975511965976;
        double d2 = this._radius * (double)2;
        HexbinGenerator hexbinGenerator = this;
        double d3 = Math.sin(d);
        hexbinGenerator.dx = d2 * d3;
        this.dy = this._radius * 1.5;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bin> invoke(@NotNull List<Point> points) {
        Intrinsics.checkParameterIsNotNull(points, (String)"points");
        Map binsById = new LinkedHashMap();
        List bins = new ArrayList();
        Iterable $receiver$iv = points;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            String id;
            Bin bin;
            int pj2;
            double py2;
            int pi2;
            double px2;
            double px1;
            void point;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Point point2 = (Point)item$iv;
            int index = n2;
            double px = ((Number)this.x.invoke((Object)point, (Object)index, points)).doubleValue();
            double py = ((Number)this.y.invoke((Object)point, (Object)index, points)).doubleValue();
            double d = px;
            if (Double.isNaN(d) || Double.isNaN(d = py)) continue;
            int pj = (int)Math.rint(py /= this.dy);
            px = px / this.dx - (double)(pj & 1) / 2.0;
            int pi = (int)Math.rint(px);
            double py1 = py - (double)pj;
            if (Math.abs(py1) * 3.0 > 1.0 && (px1 = px - (double)pi) * px1 + py1 * py1 > (px2 = px - (double)(pi2 = pi + (px < (double)pi ? -1 : 1) / 2)) * px2 + (py2 = py - (double)(pj2 = pj + (py < (double)pj ? -1 : 1))) * py2) {
                pi = pi2 + ((pj & 1) != 0 ? 1 : -1) / 2;
                pj = pj2;
            }
            if ((bin = (Bin)binsById.get(id = "" + pi + '-' + pj)) != null) {
                bin.getPoints().add((Point)point);
                continue;
            }
            bin = new Bin(CollectionsKt.mutableListOf((Object[])new Point[]{point}), ((double)pi + (double)(pj & 1) / 2.0) * this.dx, (double)pj * this.dy);
            Map map = binsById;
            Bin bin2 = bin;
            map.put(id, bin2);
            bins.add(bin);
        }
        return bins;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Point> hexagon(double radius) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)HexbinKt.access$getHexagon$p();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Point point = (Point)item$iv$iv;
            Collection collection = destination$iv$iv;
            Point point2 = it.times((Number)radius);
            collection.add(point2);
        }
        return (List)destination$iv$iv;
    }

    public final void hexagon(@NotNull Path path, @NotNull Point origin, @Nullable Double radius) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        List<Point> hex = this.hexagon(radius == null ? this._radius : radius);
        path.moveTo(origin.getX() + hex.get(0).getX(), origin.getY() + hex.get(0).getY());
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)hex.size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            path.lineTo(origin.getX() + hex.get(index).getX(), origin.getY() + hex.get(index).getY());
        }
        path.closePath();
    }

    public static /* synthetic */ void hexagon$default(HexbinGenerator hexbinGenerator, Path path, Point point, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        hexbinGenerator.hexagon(path, point, d);
    }

    @NotNull
    public final List<Point> centers() {
        List centers = new ArrayList();
        double d = this.extent.getY0() / this.dy;
        int j = (int)Math.rint(d);
        double d2 = this.extent.getX0() / this.dx;
        int i = (int)Math.rint(d2);
        double widthLimit = this.extent.getX1() + this.dx / (double)2;
        double heightLimit = this.extent.getY1() + this._radius;
        double _y = (double)j * this.dy;
        while (_y < heightLimit) {
            for (double _x = (double)i * this.dx + (double)(j & 1) * (this.dx / 2.0); _x < widthLimit; _x += this.dx) {
                centers.add(new Point(_x, _y));
            }
            _y += this.dy;
            ++j;
        }
        return centers;
    }

    public final void mesh(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        List<Point> fragment = this.hexagon(this._radius).subList(0, 4);
        List<Point> centers = this.centers();
        Iterable $receiver$iv = centers;
        for (Object element$iv : $receiver$iv) {
            Point center = (Point)element$iv;
            path.moveTo(center.getX() + fragment.get(0).getX(), center.getY() + fragment.get(0).getY());
            Iterable $receiver$iv2 = (Iterable)RangesKt.until((int)1, (int)4);
            Iterator iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                int element$iv2;
                int index = element$iv2 = ((IntIterator)iterator).nextInt();
                path.lineTo(center.getX() + fragment.get(index).getX(), center.getY() + fragment.get(index).getY());
            }
            path.closePath();
        }
    }

    public HexbinGenerator() {
        double d = 1.0471975511965976;
        double d2 = 2.0;
        HexbinGenerator hexbinGenerator = this;
        double d3 = Math.sin(d);
        hexbinGenerator.dx = d2 * d3;
        this.dy = 1.5;
        this._radius = 1.0;
    }
}

