/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import io.data2viz.color.ColorOrGradient;
import io.data2viz.geom.Arc;
import io.data2viz.geom.ArcTo;
import io.data2viz.geom.BezierCurveTo;
import io.data2viz.geom.ClosePath;
import io.data2viz.geom.LineTo;
import io.data2viz.geom.MoveTo;
import io.data2viz.geom.PathCommand;
import io.data2viz.geom.QuadraticCurveTo;
import io.data2viz.geom.RectCmd;
import io.data2viz.math.Angle;
import io.data2viz.math.AngleKt;
import io.data2viz.viz.PathNode;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.shape.StrokeLineCap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\f"}, d2={"length", "", "Lio/data2viz/geom/Arc;", "getLength", "(Lio/data2viz/geom/Arc;)D", "start", "getStart", "render", "", "Lio/data2viz/viz/PathNode;", "gc", "Ljavafx/scene/canvas/GraphicsContext;", "d2v-viz-jfx"})
public final class JfxPathRendererKt {
    public static final void render(@NotNull PathNode $receiver, @NotNull GraphicsContext gc) {
        block10: {
            ColorOrGradient it;
            ColorOrGradient colorOrGradient;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)gc, (String)"gc");
            gc.beginPath();
            Iterable $receiver$iv = $receiver.getPath().getCommands();
            for (Object element$iv : $receiver$iv) {
                PathCommand cmd = (PathCommand)element$iv;
                PathCommand pathCommand = cmd;
                if (pathCommand instanceof MoveTo) {
                    gc.moveTo(cmd.getX(), cmd.getY());
                    continue;
                }
                if (pathCommand instanceof LineTo) {
                    gc.lineTo(cmd.getX(), cmd.getY());
                    continue;
                }
                if (pathCommand instanceof QuadraticCurveTo) {
                    gc.quadraticCurveTo(((QuadraticCurveTo)cmd).getCpx(), ((QuadraticCurveTo)cmd).getCpy(), cmd.getX(), cmd.getY());
                    continue;
                }
                if (pathCommand instanceof BezierCurveTo) {
                    gc.bezierCurveTo(((BezierCurveTo)cmd).getCpx1(), ((BezierCurveTo)cmd).getCpy1(), ((BezierCurveTo)cmd).getCpx2(), ((BezierCurveTo)cmd).getCpy2(), cmd.getX(), cmd.getY());
                    continue;
                }
                if (pathCommand instanceof Arc) {
                    gc.arc(((Arc)cmd).getCenterX(), ((Arc)cmd).getCenterY(), ((Arc)cmd).getRadius(), ((Arc)cmd).getRadius(), JfxPathRendererKt.getStart((Arc)cmd), JfxPathRendererKt.getLength((Arc)cmd));
                    continue;
                }
                if (pathCommand instanceof ArcTo) {
                    gc.arcTo(((ArcTo)cmd).getFromX(), ((ArcTo)cmd).getFromY(), cmd.getX(), cmd.getY(), ((ArcTo)cmd).getRadius());
                    continue;
                }
                if (pathCommand instanceof ClosePath) {
                    gc.closePath();
                    continue;
                }
                if (pathCommand instanceof RectCmd) {
                    gc.rect(cmd.getX(), cmd.getY(), ((RectCmd)cmd).getW(), ((RectCmd)cmd).getH());
                    continue;
                }
                String string = "Unknown canvas command: " + Reflection.getOrCreateKotlinClass(cmd.getClass());
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ColorOrGradient colorOrGradient2 = $receiver.getFill();
            if (colorOrGradient2 != null) {
                it = colorOrGradient = colorOrGradient2;
                gc.fill();
            }
            ColorOrGradient colorOrGradient3 = $receiver.getStroke();
            if (colorOrGradient3 == null) break block10;
            it = colorOrGradient = colorOrGradient3;
            gc.setLineCap(StrokeLineCap.BUTT);
            gc.stroke();
        }
    }

    public static final double getStart(@NotNull Arc $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return -AngleKt.toDegrees((double)$receiver.getStartAngle());
    }

    public static final double getLength(@NotNull Arc $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        double length = Angle.constructor-impl((double)($receiver.getEndAngle() - $receiver.getStartAngle()));
        if ($receiver.getCounterClockWise() && length > 1.0E-6) {
            length = Angle.constructor-impl((double)(length % (Math.PI * 2) - Math.PI * 2));
        }
        if (!$receiver.getCounterClockWise() && length < -1.0E-6) {
            length = Angle.constructor-impl((double)(length % (Math.PI * 2) + Math.PI * 2));
        }
        return -Angle.getDeg-impl((double)length);
    }
}

