/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hierarchy.pack;

import io.data2viz.hierarchy.CircleValues;
import io.data2viz.hierarchy.pack.Circle;
import io.data2viz.hierarchy.pack.SiblingsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u00a8\u0006\u0013"}, d2={"enclose", "Lio/data2viz/hierarchy/CircleValues;", "circles", "", "encloseBasis", "B", "encloseBasis1", "Lio/data2viz/hierarchy/pack/Circle;", "a", "encloseBasis2", "b", "encloseBasis3", "c", "enclosesNot", "", "enclosesWeak", "enclosesWeakAll", "extendBasis", "p", "hierarchy"})
public final class EncloseKt {
    @Nullable
    public static final CircleValues enclose(@NotNull List<? extends CircleValues> circles) {
        Intrinsics.checkNotNullParameter(circles, (String)"circles");
        int i = 0;
        List shuffledCircles = CollectionsKt.shuffled((Iterable)circles);
        int n = shuffledCircles.size();
        boolean bl = false;
        List<CircleValues> B = CollectionsKt.emptyList();
        CircleValues e = null;
        while (i < n) {
            CircleValues p = (CircleValues)shuffledCircles.get(i);
            if (e != null && EncloseKt.enclosesWeak(e, p)) {
                int n2 = i;
                i = n2 + 1;
                continue;
            }
            B = EncloseKt.extendBasis((List<? extends CircleValues>)B, p);
            e = EncloseKt.encloseBasis(B);
            i = 0;
        }
        return e;
    }

    private static final boolean enclosesWeak(CircleValues a, CircleValues b) {
        double dr = a.getR() - b.getR() + SiblingsKt.getEpsilon();
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        return dr > 0.0 && dr * dr > dx * dx + dy * dy;
    }

    private static final boolean enclosesWeakAll(CircleValues a, List<? extends CircleValues> B) {
        int n = 0;
        int n2 = B.size();
        if (n < n2) {
            do {
                int i;
                if (EncloseKt.enclosesWeak(a, B.get(i = n++))) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    private static final boolean enclosesNot(CircleValues a, CircleValues b) {
        double dr = a.getR() - b.getR();
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        return dr < 0.0 || dr * dr < dx * dx + dy * dy;
    }

    private static final CircleValues encloseBasis(List<? extends CircleValues> B) {
        int n = B.size();
        switch (n) {
            case 1: {
                return EncloseKt.encloseBasis1(B.get(0));
            }
            case 2: {
                return EncloseKt.encloseBasis2(B.get(0), B.get(1));
            }
        }
        return EncloseKt.encloseBasis3(B.get(0), B.get(1), B.get(2));
    }

    private static final Circle encloseBasis1(CircleValues a) {
        return new Circle(a.getX(), a.getY(), a.getR());
    }

    private static final CircleValues encloseBasis2(CircleValues a, CircleValues b) {
        double x1 = a.getX();
        double y1 = a.getY();
        double r1 = a.getR();
        double x2 = b.getX();
        double y2 = b.getY();
        double r2 = b.getR();
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double r21 = r2 - r1;
        double d = x21 * x21 + y21 * y21;
        boolean bl = false;
        double l = Math.sqrt(d);
        return new Circle((x1 + x2 + x21 / l * r21) / (double)2, (y1 + y2 + y21 / l * r21) / (double)2, (l + r1 + r2) / (double)2);
    }

    private static final CircleValues encloseBasis3(CircleValues a, CircleValues b, CircleValues c) {
        double d;
        double x1 = a.getX();
        double y1 = a.getY();
        double r1 = a.getR();
        double x2 = b.getX();
        double y2 = b.getY();
        double r2 = b.getR();
        double x3 = c.getX();
        double y3 = c.getY();
        double r3 = c.getR();
        double a2 = x1 - x2;
        double a3 = x1 - x3;
        double b2 = y1 - y2;
        double b3 = y1 - y3;
        double c2 = r2 - r1;
        double c3 = r3 - r1;
        double d1 = x1 * x1 + y1 * y1 - r1 * r1;
        double d2 = d1 - x2 * x2 - y2 * y2 + r2 * r2;
        double d3 = d1 - x3 * x3 - y3 * y3 + r3 * r3;
        double ab = a3 * b2 - a2 * b3;
        double xa = (b2 * d3 - b3 * d2) / (ab * (double)2) - x1;
        double xb = (b3 * c2 - b2 * c3) / ab;
        double ya = (a3 * d2 - a2 * d3) / (ab * (double)2) - y1;
        double yb = (a2 * c3 - a3 * c2) / ab;
        double A = xb * xb + yb * yb - 1.0;
        double B = (double)2 * (r1 + xa * xb + ya * yb);
        double C = xa * xa + ya * ya - r1 * r1;
        if (!(A == 0.0)) {
            double d4 = B * B - (double)4 * A * C;
            boolean bl = false;
            d = (B + Math.sqrt(d4)) / ((double)2 * A);
        } else {
            d = C / B;
        }
        double r = -d;
        return new Circle(x1 + xa + xb * r, y1 + ya + yb * r, r);
    }

    private static final List<CircleValues> extendBasis(List<? extends CircleValues> B, CircleValues p) {
        int i;
        if (EncloseKt.enclosesWeakAll(p, B)) {
            return CollectionsKt.listOf((Object)p);
        }
        int n = 0;
        int n2 = B.size();
        if (n < n2) {
            do {
                if (!EncloseKt.enclosesNot(p, B.get(i = n++)) || !EncloseKt.enclosesWeakAll(EncloseKt.encloseBasis2(B.get(i), p), B)) continue;
                Object[] objectArray = new CircleValues[]{B.get(i), p};
                return CollectionsKt.listOf((Object[])objectArray);
            } while (n < n2);
        }
        if ((n = 0) < (n2 = B.size() - 1)) {
            do {
                int n3;
                int n4;
                if ((n4 = (i = n++) + 1) >= (n3 = B.size())) continue;
                do {
                    int j = n4++;
                    if (!EncloseKt.enclosesNot(EncloseKt.encloseBasis2(B.get(i), B.get(j)), p) || !EncloseKt.enclosesNot(EncloseKt.encloseBasis2(B.get(i), p), B.get(j)) || !EncloseKt.enclosesNot(EncloseKt.encloseBasis2(B.get(j), p), B.get(i)) || !EncloseKt.enclosesWeakAll(EncloseKt.encloseBasis3(B.get(i), B.get(j), p), B)) continue;
                    Object[] objectArray = new CircleValues[]{B.get(i), B.get(j), p};
                    return CollectionsKt.listOf((Object[])objectArray);
                } while (n4 < n3);
            } while (n < n2);
        }
        throw new RuntimeException("Unable to compute enclosing circle for PackLayout.");
    }
}

