/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hierarchy.pack;

import io.data2viz.hierarchy.CircleValues;
import io.data2viz.hierarchy.PackLayoutKt;
import io.data2viz.hierarchy.PackNode;
import io.data2viz.hierarchy.pack.EncloseKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\"\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\fH\u0000\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0013"}, d2={"epsilon", "", "getEpsilon", "()D", "intersects", "", "a", "Lio/data2viz/hierarchy/CircleValues;", "b", "packEnclose", "D", "circles", "", "Lio/data2viz/hierarchy/PackNode;", "place", "", "c", "score", "node", "hierarchy"})
public final class SiblingsKt {
    private static final double epsilon = 1.0E-6;

    public static final double getEpsilon() {
        return epsilon;
    }

    public static final <D> double packEnclose(@NotNull List<PackNode<D>> circles) {
        PackNode[] k;
        Intrinsics.checkNotNullParameter(circles, (String)"circles");
        if (circles.isEmpty()) {
            return 0.0;
        }
        int n = circles.size();
        PackNode[] a = null;
        a = CollectionsKt.first(circles);
        ((PackNode)a).setX(0.0);
        ((PackNode)a).setY(0.0);
        if (n < 2) {
            return ((PackNode)a).getR();
        }
        PackNode<D> b = circles.get(1);
        ((PackNode)a).setX(-b.getR());
        b.setX(((PackNode)a).getR());
        b.setY(0.0);
        if (n < 3) {
            return ((PackNode)a).getR() + b.getR();
        }
        PackNode<D> c = circles.get(2);
        SiblingsKt.place(b, (CircleValues)a, c);
        a = PackLayoutKt.packNode((PackNode)a);
        b = PackLayoutKt.packNode(b);
        c = PackLayoutKt.packNode(c);
        a.setNext(b);
        c.setPrevious(b);
        b.setNext(c);
        a.setPrevious(c);
        c.setNext((PackNode<D>)a);
        b.setPrevious((PackNode<D>)a);
        int i = 3;
        block0: while (i < n) {
            PackNode<D> j;
            c = circles.get(i);
            int n2 = i;
            i = n2 + 1;
            SiblingsKt.place((CircleValues)a, b, c);
            Intrinsics.checkNotNull(b.getNext());
            Intrinsics.checkNotNull(a.getPrevious());
            double sj = b.getR();
            double sk = a.getR();
            do {
                if (sj <= sk) {
                    if (SiblingsKt.intersects(j, c)) {
                        b = j;
                        a.setNext(b);
                        b.setPrevious((PackNode<D>)a);
                        int n3 = i;
                        i = n3 + -1;
                        continue block0;
                    }
                    sj += j.getR();
                    Intrinsics.checkNotNull(j.getNext());
                    continue;
                }
                if (SiblingsKt.intersects((CircleValues)k, c)) {
                    a = k;
                    a.setNext(b);
                    b.setPrevious((PackNode<D>)a);
                    int n4 = i;
                    i = n4 + -1;
                    continue block0;
                }
                sk += k.getR();
                Intrinsics.checkNotNull(k.getPrevious());
            } while (j != k.getNext());
            c.setPrevious((PackNode<D>)a);
            c.setNext(b);
            b = c;
            b.setPrevious(c);
            a.setNext(c);
            double aa = SiblingsKt.score(a);
            PackNode<D> packNode = c.getNext();
            Intrinsics.checkNotNull(packNode);
            c = packNode;
            while (c != b) {
                double ca = SiblingsKt.score(c);
                if (ca < aa) {
                    a = c;
                    aa = ca;
                }
                Intrinsics.checkNotNull(c.getNext());
            }
            PackNode packNode2 = a.getNext();
            Intrinsics.checkNotNull(packNode2);
            b = packNode2;
        }
        k = new PackNode[]{b};
        List chain = CollectionsKt.mutableListOf((Object[])k);
        c = b;
        PackNode<D> packNode = c.getNext();
        Intrinsics.checkNotNull(packNode);
        c = packNode;
        while (!Intrinsics.areEqual(c, b)) {
            chain.add(c);
            Intrinsics.checkNotNull(c.getNext());
        }
        CircleValues circleValues = EncloseKt.enclose(chain);
        Intrinsics.checkNotNull((Object)circleValues);
        CircleValues circle = circleValues;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)n);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            a = circles.get(it);
            PackNode packNode3 = (PackNode)a;
            packNode3.setX(packNode3.getX() - circle.getX());
            packNode3 = (PackNode)a;
            packNode3.setY(packNode3.getY() - circle.getY());
        }
        return circle.getR();
    }

    private static final <D> double score(PackNode<D> node) {
        PackNode<D> a = node;
        PackNode<D> packNode = node.getNext();
        Intrinsics.checkNotNull(packNode);
        PackNode<D> b = packNode;
        double ab = a.getR() + b.getR();
        double dx = (a.getX() * b.getR() + b.getX() * a.getR()) / ab;
        double dy = (a.getY() * b.getR() + b.getY() * a.getR()) / ab;
        return dx * dx + dy * dy;
    }

    private static final boolean intersects(CircleValues a, CircleValues b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        double dr = a.getR() + b.getR();
        return dr * dr - epsilon > dx * dx + dy * dy;
    }

    private static final void place(CircleValues a, CircleValues b, CircleValues c) {
        double dy;
        double ax = a.getX();
        double ay = a.getY();
        double da = b.getR() + c.getR();
        double db = a.getR() + c.getR();
        double dx = b.getX() - ax;
        double dc = dx * dx + (dy = b.getY() - ay) * dy;
        if (!(dc == 0.0)) {
            db *= db;
            da *= da;
            double x = 0.5 + (db - da) / ((double)2 * dc);
            double temp1 = 2.0 * da * (db + dc);
            double d = 0.0;
            double d2 = temp1 - (db -= dc) * db - da * da;
            boolean bl = false;
            d = Math.max(d, d2);
            boolean bl2 = false;
            double y = Math.sqrt(d) / ((double)2 * dc);
            c.setX(ax + x * dx + y * dy);
            c.setY(ay + x * dy - y * dx);
        } else {
            c.setX(ax + db);
            c.setY(ay);
        }
    }
}

