/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hierarchy.treemap;

import io.data2viz.hierarchy.ParentValued;
import io.data2viz.hierarchy.TreemapNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u001a@\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001a@\u0010\u000b\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001a@\u0010\f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"treemapDice", "", "D", "parent", "Lio/data2viz/hierarchy/ParentValued;", "Lio/data2viz/hierarchy/TreemapNode;", "x0", "", "y0", "x1", "y1", "treemapSlice", "treemapSliceDice", "hierarchy"})
public final class SliceDiceKt {
    public static final <D> void treemapSlice(@NotNull ParentValued<TreemapNode<D>> parent, double x0, double y0, double x1, double y1) {
        double k;
        double d;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        double newY = y0;
        List<ParentValued<TreemapNode<D>>> nodes = parent.getChildren();
        int i = 0;
        int n = nodes.size();
        if (parent.getValue() != null && !Intrinsics.areEqual((Double)parent.getValue(), (double)0.0)) {
            Double d2 = parent.getValue();
            Intrinsics.checkNotNull((Object)d2);
            d = (y1 - newY) / d2;
        } else {
            d = k = 0.0;
        }
        while (i < n) {
            TreemapNode node = (TreemapNode)nodes.get(i);
            node.setX0(x0);
            node.setX1(x1);
            node.setY0(newY);
            Double d3 = node.getValue();
            Intrinsics.checkNotNull((Object)d3);
            node.setY1(newY += k * d3);
            int n2 = i;
            i = n2 + 1;
        }
    }

    public static final <D> void treemapDice(@NotNull ParentValued<TreemapNode<D>> parent, double x0, double y0, double x1, double y1) {
        double k;
        double d;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        double newX = x0;
        List<ParentValued<TreemapNode<D>>> nodes = parent.getChildren();
        int i = 0;
        int n = nodes.size();
        if (parent.getValue() != null && !Intrinsics.areEqual((Double)parent.getValue(), (double)0.0)) {
            Double d2 = parent.getValue();
            Intrinsics.checkNotNull((Object)d2);
            d = (x1 - newX) / d2;
        } else {
            d = k = 0.0;
        }
        while (i < n) {
            TreemapNode node = (TreemapNode)nodes.get(i);
            node.setY0(y0);
            node.setY1(y1);
            node.setX0(newX);
            Double d3 = node.getValue();
            Intrinsics.checkNotNull((Object)d3);
            node.setX1(newX += k * d3);
            int n2 = i;
            i = n2 + 1;
        }
    }

    public static final <D> void treemapSliceDice(@NotNull ParentValued<TreemapNode<D>> parent, double x0, double y0, double x1, double y1) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        if (((TreemapNode)parent).getDepth() % 2 == 1) {
            SliceDiceKt.treemapSlice(parent, x0, y0, x1, y1);
        } else {
            SliceDiceKt.treemapDice(parent, x0, y0, x1, y1);
        }
    }
}

