/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hierarchy.treemap;

import io.data2viz.hierarchy.ParentValued;
import io.data2viz.hierarchy.Row;
import io.data2viz.hierarchy.TreemapNode;
import io.data2viz.hierarchy.treemap.SliceDiceKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001aP\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001aL\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0005\"\u0004\b\u0000\u0010\u00072\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\n0\u00102\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"phi", "", "getPhi", "()D", "squarifyRatio", "", "Lio/data2viz/hierarchy/Row;", "D", "ratio", "parent", "Lio/data2viz/hierarchy/TreemapNode;", "x0", "y0", "x1", "y1", "treemapSquarify", "Lio/data2viz/hierarchy/ParentValued;", "hierarchy"})
public final class SquarifyKt {
    private static final double phi;

    public static final double getPhi() {
        return phi;
    }

    @NotNull
    public static final <D> List<Row<D>> treemapSquarify(@NotNull ParentValued<TreemapNode<D>> parent, double x0, double y0, double x1, double y1) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return SquarifyKt.squarifyRatio(phi, (TreemapNode)parent, x0, y0, x1, y1);
    }

    private static final <D> List<Row<D>> squarifyRatio(double ratio, TreemapNode<D> parent, double x0, double y0, double x1, double y1) {
        boolean bl = false;
        List rows = new ArrayList();
        List<TreemapNode<D>> nodes = parent.getChildren();
        double newx = x0;
        double newY = y0;
        int i0 = 0;
        int i1 = 0;
        int size = nodes.size();
        double dx = 0.0;
        double dy = 0.0;
        Double d = parent.getValue();
        Intrinsics.checkNotNull((Object)d);
        double value = d;
        double sumValue = 0.0;
        while (i0 < size) {
            double temp;
            Double d2;
            dx = x1 - newx;
            dy = y1 - newY;
            do {
                int n = i1;
                i1 = n + 1;
                d2 = nodes.get(n).getValue();
                Intrinsics.checkNotNull((Object)d2);
            } while ((sumValue = d2.doubleValue()) == 0.0 && i1 < size);
            double minValue = sumValue;
            double maxValue = sumValue;
            double d3 = dy / dx;
            double d4 = dx / dy;
            boolean bl2 = false;
            double alpha = Math.max(d3, d4) / (value * ratio);
            double beta = sumValue * sumValue * alpha;
            double d5 = maxValue / beta;
            double d6 = beta / minValue;
            int n = 0;
            double minRatio = Math.max(d5, d6);
            while (i1 < size) {
                Double d7 = nodes.get(i1).getValue();
                Intrinsics.checkNotNull((Object)d7);
                double nodeValue = d7;
                sumValue += nodeValue;
                if (nodeValue < minValue) {
                    minValue = nodeValue;
                }
                if (nodeValue > maxValue) {
                    maxValue = nodeValue;
                }
                beta = sumValue * sumValue * alpha;
                double d8 = maxValue / beta;
                double d9 = beta / minValue;
                boolean bl3 = false;
                double newRatio = Math.max(d8, d9);
                if (newRatio > minRatio) {
                    sumValue -= nodeValue;
                    break;
                }
                minRatio = newRatio;
                n = i1;
                i1 = n + 1;
            }
            Row row = new Row(sumValue, dx < dy, CollectionsKt.slice(nodes, (IntRange)RangesKt.until((int)i0, (int)i1)));
            rows.add(row);
            if (row.getDice()) {
                if (!(value == 0.0)) {
                    temp = newY + dy * sumValue / value;
                    SliceDiceKt.treemapDice(row, newx, newY, x1, temp);
                    newY = temp;
                } else {
                    SliceDiceKt.treemapDice(row, newx, newY, x1, y1);
                }
            } else if (!(value == 0.0)) {
                temp = newx + dx * sumValue / value;
                SliceDiceKt.treemapSlice(row, newx, newY, temp, y1);
                newx = temp;
            } else {
                SliceDiceKt.treemapSlice(row, newx, newY, x1, y1);
            }
            value -= sumValue;
            i0 = i1;
        }
        return CollectionsKt.toList((Iterable)rows);
    }

    static {
        double d = 5.0;
        boolean bl = false;
        phi = (1.0 + Math.sqrt(d)) / (double)2;
    }
}

