/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.hierarchy.treemap;

import io.data2viz.hierarchy.ParentValued;
import io.data2viz.hierarchy.TreemapNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u00062\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ@\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002R,\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lio/data2viz/hierarchy/treemap/TreemapBinary;", "D", "", "()V", "nodes", "", "Lio/data2viz/hierarchy/ParentValued;", "Lio/data2viz/hierarchy/TreemapNode;", "getNodes", "()Ljava/util/List;", "setNodes", "(Ljava/util/List;)V", "sums", "", "getSums", "setSums", "binary", "", "parent", "x0", "y0", "x1", "y1", "partition", "i", "", "j", "value", "hierarchy"})
public final class TreemapBinary<D> {
    @NotNull
    private List<ParentValued<TreemapNode<D>>> nodes;
    @NotNull
    private List<Double> sums;

    public TreemapBinary() {
        boolean bl = false;
        this.nodes = new ArrayList();
        bl = false;
        this.sums = new ArrayList();
    }

    @NotNull
    public final List<ParentValued<TreemapNode<D>>> getNodes() {
        return this.nodes;
    }

    public final void setNodes(@NotNull List<ParentValued<TreemapNode<D>>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.nodes = list;
    }

    @NotNull
    public final List<Double> getSums() {
        return this.sums;
    }

    public final void setSums(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sums = list;
    }

    public final void binary(@NotNull ParentValued<TreemapNode<D>> parent, double x0, double y0, double x1, double y1) {
        ArrayList<Double> arrayList;
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this.nodes = CollectionsKt.toMutableList((Collection)parent.getChildren());
        int size = this.nodes.size();
        int n = size + 1;
        TreemapBinary treemapBinary = this;
        boolean bl = false;
        ArrayList<Double> arrayList2 = new ArrayList<Double>(n);
        boolean bl2 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl3 = false;
            int n5 = n4;
            arrayList = arrayList2;
            boolean bl4 = false;
            Double d = 0.0;
            arrayList.add(d);
        }
        treemapBinary.sums = arrayList = (ArrayList<Double>)arrayList2;
        double sum = 0.0;
        int n6 = 0;
        if (n6 < size) {
            do {
                int i = n6++;
                Double d = this.nodes.get(i).getValue();
                Intrinsics.checkNotNull((Object)d);
                this.sums.set(i + 1, sum += d.doubleValue());
            } while (n6 < size);
        }
        Double d = parent.getValue();
        Intrinsics.checkNotNull((Object)d);
        this.partition(0, size, d, x0, y0, x1, y1);
    }

    private final void partition(int i, int j, double value, double x0, double y0, double x1, double y1) {
        if (i >= j - 1) {
            TreemapNode node = (TreemapNode)this.nodes.get(i);
            node.setX0(x0);
            node.setY0(y0);
            node.setX1(x1);
            node.setY1(y1);
            return;
        }
        double valueOffset = ((Number)this.sums.get(i)).doubleValue();
        double valueTarget = value / (double)2 + valueOffset;
        int k = i + 1;
        int hi = j - 1;
        while (k < hi) {
            int mid = k + hi >>> 1;
            if (((Number)this.sums.get(mid)).doubleValue() < valueTarget) {
                k = mid + 1;
                continue;
            }
            hi = mid;
        }
        if (valueTarget - ((Number)this.sums.get(k - 1)).doubleValue() < ((Number)this.sums.get(k)).doubleValue() - valueTarget && i + 1 < k) {
            --k;
        }
        double valueLeft = ((Number)this.sums.get(k)).doubleValue() - valueOffset;
        double valueRight = value - valueLeft;
        if (x1 - x0 > y1 - y0) {
            double xk = (x0 * valueRight + x1 * valueLeft) / value;
            this.partition(i, k, valueLeft, x0, y0, xk, y1);
            this.partition(k, j, valueRight, xk, y0, x1, y1);
        } else {
            double yk = (y0 * valueRight + y1 * valueLeft) / value;
            this.partition(i, k, valueLeft, x0, y0, x1, yk);
            this.partition(k, j, valueRight, x0, yk, x1, y1);
        }
    }
}

