/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape;

import io.data2viz.geom.Path;
import io.data2viz.shape.CornerTangentValues;
import io.data2viz.shape.LineBuilderKt;
import io.data2viz.shape.MathKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J%\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0001\u0010\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u0002H\u001e\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010%J@\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002JS\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060$2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u00105R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR(\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\n\u00a8\u00066"}, d2={"Lio/data2viz/shape/ArcBuilder;", "D", "", "()V", "cornerRadius", "Lkotlin/Function1;", "", "getCornerRadius", "()Lkotlin/jvm/functions/Function1;", "setCornerRadius", "(Lkotlin/jvm/functions/Function1;)V", "endAngle", "getEndAngle", "setEndAngle", "innerRadius", "getInnerRadius", "setInnerRadius", "outerRadius", "getOuterRadius", "setOuterRadius", "padAngle", "getPadAngle", "setPadAngle", "padRadius", "getPadRadius", "setPadRadius", "startAngle", "getStartAngle", "setStartAngle", "buildArcForDatum", "C", "Lio/data2viz/geom/Path;", "datum", "path", "(Ljava/lang/Object;Lio/data2viz/geom/Path;)Lio/data2viz/geom/Path;", "centroid", "", "(Ljava/lang/Object;)[Ljava/lang/Double;", "cornerTangents", "Lio/data2viz/shape/CornerTangentValues;", "x0", "y0", "x1", "y1", "r1", "rc", "cw", "", "intersect", "x2", "y2", "x3", "y3", "(DDDDDDDD)[Ljava/lang/Double;", "shape"})
public final class ArcBuilder<D> {
    @NotNull
    private Function1<? super D, Double> innerRadius = LineBuilderKt.const(0.0);
    @NotNull
    private Function1<? super D, Double> outerRadius = LineBuilderKt.const(100.0);
    @NotNull
    private Function1<? super D, Double> cornerRadius = LineBuilderKt.const(0.0);
    @Nullable
    private Function1<? super D, Double> padRadius;
    @NotNull
    private Function1<? super D, Double> startAngle = LineBuilderKt.const(0.0);
    @NotNull
    private Function1<? super D, Double> endAngle = LineBuilderKt.const(0.0);
    @NotNull
    private Function1<? super D, Double> padAngle = LineBuilderKt.const(0.0);

    @NotNull
    public final Function1<D, Double> getInnerRadius() {
        return this.innerRadius;
    }

    public final void setInnerRadius(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.innerRadius = function1;
    }

    @NotNull
    public final Function1<D, Double> getOuterRadius() {
        return this.outerRadius;
    }

    public final void setOuterRadius(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.outerRadius = function1;
    }

    @NotNull
    public final Function1<D, Double> getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.cornerRadius = function1;
    }

    @Nullable
    public final Function1<D, Double> getPadRadius() {
        return this.padRadius;
    }

    public final void setPadRadius(@Nullable Function1<? super D, Double> function1) {
        this.padRadius = function1;
    }

    @NotNull
    public final Function1<D, Double> getStartAngle() {
        return this.startAngle;
    }

    public final void setStartAngle(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.startAngle = function1;
    }

    @NotNull
    public final Function1<D, Double> getEndAngle() {
        return this.endAngle;
    }

    public final void setEndAngle(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.endAngle = function1;
    }

    @NotNull
    public final Function1<D, Double> getPadAngle() {
        return this.padAngle;
    }

    public final void setPadAngle(@NotNull Function1<? super D, Double> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.padAngle = function1;
    }

    @NotNull
    public final Double[] centroid(D datum) {
        double r = ((Number)this.innerRadius.invoke(datum)).doubleValue() + ((Number)this.outerRadius.invoke(datum)).doubleValue() / 2.0;
        double a = ((Number)this.startAngle.invoke(datum)).doubleValue() + ((Number)this.endAngle.invoke(datum)).doubleValue() / 2.0 - MathKt.getHalfPi();
        Double[] doubleArray = new Double[2];
        boolean bl = false;
        doubleArray[0] = Math.cos(a) * r;
        bl = false;
        doubleArray[1] = Math.sin(a) * r;
        return doubleArray;
    }

    @NotNull
    public final <C extends Path> C buildArcForDatum(D datum, @NotNull C path) {
        boolean cw;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        double r0 = ((Number)this.innerRadius.invoke(datum)).doubleValue();
        double r1 = ((Number)this.outerRadius.invoke(datum)).doubleValue();
        double a0 = ((Number)this.startAngle.invoke(datum)).doubleValue() - MathKt.getHalfPi();
        double a1 = ((Number)this.endAngle.invoke(datum)).doubleValue() - MathKt.getHalfPi();
        double d = a1 - a0;
        boolean bl = false;
        double da = Math.abs(d);
        boolean bl2 = cw = a1 > a0;
        if (r1 < r0) {
            double r = r1;
            r1 = r0;
            r0 = r;
        }
        if (r1 <= MathKt.getEpsilon()) {
            path.moveTo(0.0, 0.0);
        } else if (da > MathKt.getTau() - MathKt.getEpsilon()) {
            boolean r = false;
            r = false;
            path.moveTo(r1 * Math.cos(a0), r1 * Math.sin(a0));
            path.arc(0.0, 0.0, r1, a0, a1, !cw);
            if (r0 > MathKt.getEpsilon()) {
                r = false;
                r = false;
                path.moveTo(r0 * Math.cos(a1), r0 * Math.sin(a1));
                path.arc(0.0, 0.0, r0, a1, a0, cw);
            }
        } else {
            boolean bl3;
            double d2;
            double d3;
            double rc;
            boolean bl4;
            double d4;
            double d5;
            double a01 = a0;
            double a11 = a1;
            double a00 = a0;
            double a10 = a1;
            double da0 = da;
            double da1 = da;
            double ap = ((Number)this.padAngle.invoke(datum)).doubleValue() / 2.0;
            if (ap <= MathKt.getEpsilon()) {
                d5 = 0.0;
            } else {
                double d6;
                if (this.padRadius != null) {
                    Function1<? super D, Double> function1 = this.padRadius;
                    Intrinsics.checkNotNull(function1);
                    d6 = ((Number)function1.invoke(datum)).doubleValue();
                } else {
                    d4 = r0 * r0 + r1 * r1;
                    bl4 = false;
                    d6 = Math.sqrt(d4);
                }
                double temp = d6;
                d5 = !(temp == 0.0) ? 1.0 : 0.0;
            }
            double rp = d5;
            d4 = r1 - r0;
            bl4 = false;
            d4 = Math.abs(d4) / (double)2;
            double d7 = ((Number)this.cornerRadius.invoke(datum)).doubleValue();
            boolean bl5 = false;
            double rc0 = rc = Math.min(d4, d7);
            double rc1 = rc;
            if (rp > MathKt.getEpsilon()) {
                double p0 = MathKt.asin(rp / r0 * ap);
                double p1 = MathKt.asin(rp / r1 * ap);
                if ((da0 -= p0 * (double)2) > MathKt.getEpsilon()) {
                    a00 += (p0 *= cw ? 1.0 : -1.0);
                    a10 -= p0;
                } else {
                    da0 = 0.0;
                    a00 = a10 = (a0 + a1) / (double)2;
                }
                da1 -= p1 * (double)2;
                if (da1 > MathKt.getEpsilon()) {
                    a01 += (p1 *= cw ? 1.0 : -1.0);
                    a11 -= p1;
                } else {
                    da1 = 0.0;
                    a01 = a11 = (a0 + a1) / (double)2;
                }
            }
            boolean p1 = false;
            double x01 = r1 * Math.cos(a01);
            boolean bl6 = false;
            double y01 = r1 * Math.sin(a01);
            boolean bl7 = false;
            double x10 = r0 * Math.cos(a10);
            boolean bl8 = false;
            double y10 = r0 * Math.sin(a10);
            boolean bl9 = false;
            double x11 = r1 * Math.cos(a11);
            boolean bl10 = false;
            double y11 = r1 * Math.sin(a11);
            boolean bl11 = false;
            double x00 = r0 * Math.cos(a00);
            boolean bl12 = false;
            double y00 = r0 * Math.sin(a00);
            if (rc > MathKt.getEpsilon() && da < MathKt.getPi()) {
                Double[] doubleArray;
                if (da0 > MathKt.getEpsilon()) {
                    doubleArray = this.intersect(x01, y01, x00, y00, x11, y11, x10, y10);
                } else {
                    Double[] doubleArray2 = new Double[]{x10, y10};
                    doubleArray = doubleArray2;
                }
                Double[] oc = doubleArray;
                double ax = x01 - oc[0];
                double ay = y01 - oc[1];
                double bx = x11 - oc[0];
                double by = y11 - oc[1];
                double d8 = ax * ax + ay * ay;
                boolean bl13 = false;
                double d9 = Math.sqrt(d8);
                d8 = bx * bx + by * by;
                bl13 = false;
                d8 = MathKt.acos((ax * bx + ay * by) / (d9 * Math.sqrt(d8))) / (double)2;
                bl13 = false;
                double kc = 1.0 / Math.sin(d8);
                double d10 = oc[0] * oc[0] + oc[1] * oc[1];
                boolean bl14 = false;
                double lc = Math.sqrt(d10);
                d10 = (r0 - lc) / (kc - 1.0);
                bl14 = false;
                rc0 = Math.min(rc, d10);
                d10 = (r1 - lc) / (kc + 1.0);
                bl14 = false;
                rc1 = Math.min(rc, d10);
            }
            if (!(da1 > MathKt.getEpsilon())) {
                path.moveTo(x01, y01);
            } else if (rc1 > MathKt.getEpsilon()) {
                CornerTangentValues t0 = this.cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
                CornerTangentValues t1 = this.cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
                path.moveTo(t0.getCx() + t0.getX01(), t0.getCy() + t0.getY01());
                if (rc1 < rc) {
                    d3 = t0.getY01();
                    d2 = t0.getX01();
                    bl3 = false;
                    double d11 = Math.atan2(d3, d2);
                    d3 = t1.getY01();
                    d2 = t1.getX01();
                    bl3 = false;
                    path.arc(t0.getCx(), t0.getCy(), rc1, d11, Math.atan2(d3, d2), !cw);
                } else {
                    d3 = t0.getY01();
                    d2 = t0.getX01();
                    bl3 = false;
                    double d12 = Math.atan2(d3, d2);
                    d3 = t0.getY11();
                    d2 = t0.getX11();
                    bl3 = false;
                    path.arc(t0.getCx(), t0.getCy(), rc1, d12, Math.atan2(d3, d2), !cw);
                    d3 = t0.getCy() + t0.getY11();
                    d2 = t0.getCx() + t0.getX11();
                    bl3 = false;
                    double d13 = Math.atan2(d3, d2);
                    d3 = t1.getCy() + t1.getY11();
                    d2 = t1.getCx() + t1.getX11();
                    bl3 = false;
                    path.arc(0.0, 0.0, r1, d13, Math.atan2(d3, d2), !cw);
                    d3 = t1.getY11();
                    d2 = t1.getX11();
                    bl3 = false;
                    double d14 = Math.atan2(d3, d2);
                    d3 = t1.getY01();
                    d2 = t1.getX01();
                    bl3 = false;
                    path.arc(t1.getCx(), t1.getCy(), rc1, d14, Math.atan2(d3, d2), !cw);
                }
            } else {
                path.moveTo(x01, y01);
                path.arc(0.0, 0.0, r1, a01, a11, !cw);
            }
            if (!(r0 > MathKt.getEpsilon()) || !(da0 > MathKt.getEpsilon())) {
                path.lineTo(x10, y10);
            } else if (rc0 > MathKt.getEpsilon()) {
                CornerTangentValues t0 = this.cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
                CornerTangentValues t1 = this.cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);
                path.lineTo(t0.getCx() + t0.getX01(), t0.getCy() + t0.getY01());
                if (rc0 < rc) {
                    d3 = t0.getY01();
                    d2 = t0.getX01();
                    bl3 = false;
                    double d15 = Math.atan2(d3, d2);
                    d3 = t1.getY01();
                    d2 = t1.getX01();
                    bl3 = false;
                    path.arc(t0.getCx(), t0.getCy(), rc0, d15, Math.atan2(d3, d2), !cw);
                } else {
                    d3 = t0.getY01();
                    d2 = t0.getX01();
                    bl3 = false;
                    double d16 = Math.atan2(d3, d2);
                    d3 = t0.getY11();
                    d2 = t0.getX11();
                    bl3 = false;
                    path.arc(t0.getCx(), t0.getCy(), rc0, d16, Math.atan2(d3, d2), !cw);
                    d3 = t0.getCy() + t0.getY11();
                    d2 = t0.getCx() + t0.getX11();
                    bl3 = false;
                    double d17 = Math.atan2(d3, d2);
                    d3 = t1.getCy() + t1.getY11();
                    d2 = t1.getCx() + t1.getX11();
                    bl3 = false;
                    path.arc(0.0, 0.0, r0, d17, Math.atan2(d3, d2), cw);
                    d3 = t1.getY11();
                    d2 = t1.getX11();
                    bl3 = false;
                    double d18 = Math.atan2(d3, d2);
                    d3 = t1.getY01();
                    d2 = t1.getX01();
                    bl3 = false;
                    path.arc(t1.getCx(), t1.getCy(), rc0, d18, Math.atan2(d3, d2), !cw);
                }
            } else {
                path.arc(0.0, 0.0, r0, a10, a00, cw);
            }
        }
        path.closePath();
        return path;
    }

    private final CornerTangentValues cornerTangents(double x0, double y0, double x1, double y1, double r1, double rc, boolean cw) {
        double cy1;
        double dy1;
        double cx1;
        double dx1;
        double cy0;
        double dy0;
        double x01 = x0 - x1;
        double y01 = y0 - y1;
        double d = x01 * x01 + y01 * y01;
        boolean bl = false;
        double lo = (cw ? rc : -rc) / Math.sqrt(d);
        double ox = lo * y01;
        double oy = -lo * x01;
        double x11 = x0 + ox;
        double y11 = y0 + oy;
        double x10 = x1 + ox;
        double y10 = y1 + oy;
        double x00 = (x11 + x10) / (double)2;
        double y00 = (y11 + y10) / (double)2;
        double dx = x10 - x11;
        double dy = y10 - y11;
        double d2 = dx * dx + dy * dy;
        double r = r1 - rc;
        double D = x11 * y10 - x10 * y11;
        double d3 = 0.0;
        double d4 = r * r * d2 - D * D;
        boolean bl2 = false;
        d3 = Math.max(d3, d4);
        boolean bl3 = false;
        double d5 = (dy < 0.0 ? -1.0 : 1.0) * Math.sqrt(d3);
        double cx0 = (D * dy - dx * d5) / d2;
        double dx0 = cx0 - x00;
        if (dx0 * dx0 + (dy0 = (cy0 = (-D * dx - dy * d5) / d2) - y00) * dy0 > (dx1 = (cx1 = (D * dy + dx * d5) / d2) - x00) * dx1 + (dy1 = (cy1 = (-D * dx + dy * d5) / d2) - y00) * dy1) {
            cx0 = cx1;
            cy0 = cy1;
        }
        return new CornerTangentValues(cx0, cy0, -ox, -oy, cx0 * (r1 / r - 1.0), cy0 * (r1 / r - 1.0));
    }

    private final Double[] intersect(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double x10 = x1 - x0;
        double y10 = y1 - y0;
        double x32 = x3 - x2;
        double y32 = y3 - y2;
        double t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / (y32 * x10 - x32 * y10);
        Double[] doubleArray = new Double[]{x0 + t * x10, y0 + t * y10};
        return doubleArray;
    }
}

