/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/data2viz/shape/curve/AbstractMonotone;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "(Lio/data2viz/geom/Path;)V", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "t0", "", "x0", "x1", "y0", "y1", "areaEnd", "", "areaStart", "curve", "t1", "lineEnd", "lineStart", "point", "x", "y", "slope2", "t", "slope3", "x2", "y2", "shape"})
public class AbstractMonotone
implements Curve {
    @NotNull
    private final Path path;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double t0;
    private int lineStatus;
    private int pointStatus;

    public AbstractMonotone(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.t0 = -1.0;
        this.lineStatus = -1;
        this.pointStatus = -1;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.t0 = -1.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        int n = this.pointStatus;
        switch (n) {
            case 2: {
                this.getPath().lineTo(this.x1, this.y1);
                break;
            }
            case 3: {
                this.curve(this.t0, this.slope2(this.t0));
            }
        }
        if (this.lineStatus > -1) {
            if (this.lineStatus > 0) {
                this.getPath().closePath();
            }
            this.lineStatus = 1 - this.lineStatus;
        }
    }

    @Override
    public void point(double x, double y) {
        double t1 = -1.0;
        if (x == this.x1 && y == this.y1) {
            return;
        }
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                if (this.lineStatus > 0) {
                    this.getPath().lineTo(x, y);
                    break;
                }
                this.getPath().moveTo(x, y);
                break;
            }
            case 1: {
                this.pointStatus = 2;
                break;
            }
            case 2: {
                this.pointStatus = 3;
                t1 = this.slope3(x, y);
                this.curve(this.slope2(t1), t1);
                break;
            }
            default: {
                t1 = this.slope3(x, y);
                this.curve(this.t0, t1);
            }
        }
        this.x0 = this.x1;
        this.x1 = x;
        this.y0 = this.y1;
        this.y1 = y;
        this.t0 = t1;
    }

    private final void curve(double t0, double t1) {
        double dx = (this.x1 - this.x0) / 3.0;
        this.getPath().bezierCurveTo(this.x0 + dx, this.y0 + dx * t0, this.x1 - dx, this.y1 - dx * t1, this.x1, this.y1);
    }

    private final double slope3(double x2, double y2) {
        double value;
        double h0 = this.x1 - this.x0;
        double h1 = x2 - this.x1;
        double divider0 = !(h0 == 0.0) ? h0 : (h1 < 0.0 ? -0.0 : 0.0);
        double divider1 = !(h1 == 0.0) ? h1 : (h0 < 0.0 ? -0.0 : 0.0);
        double s0 = (this.y1 - this.y0) / divider0;
        double s1 = (y2 - this.y1) / divider1;
        double p = (s0 * h1 + s1 * h0) / (h0 + h1);
        boolean bl = false;
        double d = Math.abs(s0);
        boolean bl2 = false;
        double d2 = Math.abs(s1);
        boolean bl3 = false;
        double d3 = 0.5 * Math.abs(p);
        boolean bl4 = false;
        d2 = Math.min(d2, d3);
        boolean bl5 = false;
        d = value = (AbstractMonotone.slope3$sign(s0) + AbstractMonotone.slope3$sign(s1)) * Math.min(d, d2);
        boolean bl6 = false;
        return Double.isNaN(d) ? 0.0 : value;
    }

    private final double slope2(double t) {
        double h = this.x1 - this.x0;
        return !(h == 0.0) ? ((double)3 * (this.y1 - this.y0) / h - t) / (double)2 : t;
    }

    private static final double slope3$sign(double num) {
        return num < 0.0 ? -1.0 : 1.0;
    }
}

