/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/data2viz/shape/curve/AbstractStep;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "changePoint", "", "(Lio/data2viz/geom/Path;D)V", "_changePoint", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "x", "y", "areaEnd", "", "areaStart", "lineEnd", "lineStart", "point", "shape"})
public abstract class AbstractStep
implements Curve {
    @NotNull
    private final Path path;
    private double x;
    private double y;
    private int lineStatus;
    private int pointStatus;
    private double _changePoint;

    public AbstractStep(@NotNull Path path, double changePoint) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.x = -1.0;
        this.y = -1.0;
        this.lineStatus = -1;
        this.pointStatus = -1;
        this._changePoint = changePoint;
    }

    public /* synthetic */ AbstractStep(Path path, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        this(path, d);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x = -1.0;
        this.y = -1.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        if (0.0 < this._changePoint && this._changePoint < 1.0 && this.pointStatus == 2) {
            this.getPath().lineTo(this.x, this.y);
        }
        if (this.lineStatus > 0) {
            this.getPath().closePath();
        }
        if (this.lineStatus >= 0) {
            this._changePoint = 1.0 - this._changePoint;
            this.lineStatus = 1 - this.lineStatus;
        }
    }

    @Override
    public void point(double x, double y) {
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                if (this.lineStatus > 0) {
                    this.getPath().lineTo(x, y);
                } else {
                    this.getPath().moveTo(x, y);
                }
                this.x = x;
                this.y = y;
                return;
            }
            case 1: {
                this.pointStatus = 2;
            }
        }
        if (this._changePoint <= 0.0) {
            this.getPath().lineTo(this.x, y);
            this.getPath().lineTo(x, y);
        } else {
            double x1 = this.x * (1.0 - this._changePoint) + x * this._changePoint;
            this.getPath().lineTo(x1, this.y);
            this.getPath().lineTo(x1, y);
        }
        this.x = x;
        this.y = y;
    }
}

