/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/data2viz/shape/curve/BasisClosed;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "(Lio/data2viz/geom/Path;)V", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "", "x0", "", "x1", "x2", "x3", "x4", "y0", "y1", "y2", "y3", "y4", "areaEnd", "", "areaStart", "curve", "x", "y", "lineEnd", "lineStart", "point", "shape"})
public final class BasisClosed
implements Curve {
    @NotNull
    private final Path path;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;
    private double x4;
    private double y4;
    private int pointStatus;

    public BasisClosed(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this.x3 = -1.0;
        this.y3 = -1.0;
        this.x4 = -1.0;
        this.y4 = -1.0;
        this.pointStatus = -1;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
    }

    @Override
    public void areaEnd() {
    }

    @Override
    public void lineStart() {
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this.x3 = -1.0;
        this.y3 = -1.0;
        this.x4 = -1.0;
        this.y4 = -1.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        int n = this.pointStatus;
        switch (n) {
            case 1: {
                this.getPath().moveTo(this.x2, this.y2);
                this.getPath().closePath();
                break;
            }
            case 2: {
                this.getPath().moveTo((this.x2 + (double)2 * this.x3) / (double)3, (this.y2 + (double)2 * this.y3) / (double)3);
                this.getPath().lineTo((this.x3 + (double)2 * this.x2) / (double)3, (this.y3 + (double)2 * this.y2) / (double)3);
                this.getPath().closePath();
                break;
            }
            case 3: {
                this.point(this.x2, this.y2);
                this.point(this.x3, this.y3);
                this.point(this.x4, this.y4);
            }
        }
    }

    private final void curve(double x, double y) {
        this.getPath().bezierCurveTo(((double)2 * this.x0 + this.x1) / (double)3, ((double)2 * this.y0 + this.y1) / (double)3, (this.x0 + (double)2 * this.x1) / (double)3, (this.y0 + (double)2 * this.y1) / (double)3, (this.x0 + (double)4 * this.x1 + x) / (double)6, (this.y0 + (double)4 * this.y1 + y) / (double)6);
    }

    @Override
    public void point(double x, double y) {
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                this.x2 = x;
                this.y2 = y;
                break;
            }
            case 1: {
                this.pointStatus = 2;
                this.x3 = x;
                this.y3 = y;
                break;
            }
            case 2: {
                this.pointStatus = 3;
                this.x4 = x;
                this.y4 = y;
                this.getPath().moveTo((this.x0 + (double)4 * this.x1 + x) / (double)6, (this.y0 + (double)4 * this.y1 + y) / (double)6);
                break;
            }
            default: {
                this.curve(x, y);
            }
        }
        this.x0 = this.x1;
        this.x1 = x;
        this.y0 = this.y1;
        this.y1 = y;
    }
}

