/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/data2viz/shape/curve/BasisOpen;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "(Lio/data2viz/geom/Path;)V", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "x0", "", "x1", "y0", "y1", "areaEnd", "", "areaStart", "curve", "x", "y", "lineEnd", "lineStart", "point", "shape"})
public final class BasisOpen
implements Curve {
    @NotNull
    private final Path path;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private int lineStatus;
    private int pointStatus;

    public BasisOpen(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.lineStatus = -1;
        this.pointStatus = -1;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        if (this.lineStatus > -1) {
            if (this.lineStatus > 0) {
                this.getPath().closePath();
            }
            this.lineStatus = 1 - this.lineStatus;
        }
    }

    private final void curve(double x, double y) {
        this.getPath().bezierCurveTo(((double)2 * this.x0 + this.x1) / (double)3, ((double)2 * this.y0 + this.y1) / (double)3, (this.x0 + (double)2 * this.x1) / (double)3, (this.y0 + (double)2 * this.y1) / (double)3, (this.x0 + (double)4 * this.x1 + x) / (double)6, (this.y0 + (double)4 * this.y1 + y) / (double)6);
    }

    @Override
    public void point(double x, double y) {
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                break;
            }
            case 1: {
                this.pointStatus = 2;
                break;
            }
            case 2: {
                this.pointStatus = 3;
                double _x = (this.x0 + (double)4 * this.x1 + x) / (double)6;
                double _y = (this.y0 + (double)4 * this.y1 + y) / (double)6;
                if (this.lineStatus > 0) {
                    this.getPath().lineTo(_x, _y);
                    break;
                }
                this.getPath().moveTo(_x, _y);
                break;
            }
            case 3: {
                this.pointStatus = 4;
                this.curve(x, y);
                break;
            }
            default: {
                this.curve(x, y);
            }
        }
        this.x0 = this.x1;
        this.x1 = x;
        this.y0 = this.y1;
        this.y1 = y;
    }
}

