/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/data2viz/shape/curve/Cardinal;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "tension", "", "(Lio/data2viz/geom/Path;D)V", "k", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "x0", "x1", "x2", "y0", "y1", "y2", "areaEnd", "", "areaStart", "curve", "x", "y", "lineEnd", "lineStart", "point", "shape"})
public final class Cardinal
implements Curve {
    @NotNull
    private final Path path;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private int lineStatus;
    private int pointStatus;
    private final double k;

    public Cardinal(@NotNull Path path, double tension) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this.lineStatus = -1;
        this.pointStatus = -1;
        this.k = (1.0 - tension) / 6.0;
    }

    public /* synthetic */ Cardinal(Path path, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        this(path, d);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        int n = this.pointStatus;
        switch (n) {
            case 2: {
                this.getPath().lineTo(this.x2, this.y2);
                break;
            }
            case 3: {
                this.curve(this.x1, this.y1);
            }
        }
        if (this.lineStatus > -1) {
            if (this.lineStatus > 0) {
                this.getPath().closePath();
            }
            this.lineStatus = 1 - this.lineStatus;
        }
    }

    private final void curve(double x, double y) {
        this.getPath().bezierCurveTo(this.x1 + this.k * (this.x2 - this.x0), this.y1 + this.k * (this.y2 - this.y0), this.x2 + this.k * (this.x1 - x), this.y2 + this.k * (this.y1 - y), this.x2, this.y2);
    }

    @Override
    public void point(double x, double y) {
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                if (this.lineStatus > 0) {
                    this.getPath().lineTo(x, y);
                    break;
                }
                this.getPath().moveTo(x, y);
                break;
            }
            case 1: {
                this.pointStatus = 2;
                this.x1 = x;
                this.y1 = y;
                break;
            }
            case 2: {
                this.pointStatus = 3;
                this.curve(x, y);
                break;
            }
            default: {
                this.curve(x, y);
            }
        }
        this.x0 = this.x1;
        this.x1 = this.x2;
        this.x2 = x;
        this.y0 = this.y1;
        this.y1 = this.y2;
        this.y2 = y;
    }
}

