/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import io.data2viz.shape.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/data2viz/shape/curve/CatmullRom;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "alpha", "", "(Lio/data2viz/geom/Path;D)V", "_l01_2a", "_l01_a", "_l12_2a", "_l12_a", "_l23_2a", "_l23_a", "getAlpha", "()D", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "pointStatus", "x0", "x1", "x2", "y0", "y1", "y2", "areaEnd", "", "areaStart", "curve", "x", "y", "lineEnd", "lineStart", "point", "shape"})
public final class CatmullRom
implements Curve {
    @NotNull
    private final Path path;
    private final double alpha;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double _l01_a;
    private double _l12_a;
    private double _l23_a;
    private double _l01_2a;
    private double _l12_2a;
    private double _l23_2a;
    private int lineStatus;
    private int pointStatus;

    public CatmullRom(@NotNull Path path, double alpha) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.alpha = alpha;
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this.lineStatus = -1;
        this.pointStatus = -1;
    }

    public /* synthetic */ CatmullRom(Path path, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        this(path, d);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x0 = -1.0;
        this.y0 = -1.0;
        this.x1 = -1.0;
        this.y1 = -1.0;
        this.x2 = -1.0;
        this.y2 = -1.0;
        this._l01_a = 0.0;
        this._l12_a = 0.0;
        this._l23_a = 0.0;
        this._l01_2a = 0.0;
        this._l12_2a = 0.0;
        this._l23_2a = 0.0;
        this.pointStatus = 0;
    }

    @Override
    public void lineEnd() {
        int n = this.pointStatus;
        switch (n) {
            case 2: {
                this.getPath().lineTo(this.x2, this.y2);
                break;
            }
            case 3: {
                this.point(this.x2, this.y2);
            }
        }
        if (this.lineStatus > -1) {
            if (this.lineStatus > 0) {
                this.getPath().closePath();
            }
            this.lineStatus = 1 - this.lineStatus;
        }
    }

    private final void curve(double x, double y) {
        double _x1 = this.x1;
        double _y1 = this.y1;
        double _x2 = this.x2;
        double _y2 = this.y2;
        if (this._l01_a > MathKt.getEpsilon()) {
            double a = (double)2 * this._l01_2a + (double)3 * this._l01_a * this._l12_a + this._l12_2a;
            double n = (double)3 * this._l01_a * (this._l01_a + this._l12_a);
            _x1 = (this.x1 * a - this.x0 * this._l12_2a + this.x2 * this._l01_2a) / n;
            _y1 = (this.y1 * a - this.y0 * this._l12_2a + this.y2 * this._l01_2a) / n;
        }
        if (this._l23_a > MathKt.getEpsilon()) {
            double b = (double)2 * this._l23_2a + (double)3 * this._l23_a * this._l12_a + this._l12_2a;
            double m = (double)3 * this._l23_a * (this._l23_a + this._l12_a);
            _x2 = (this.x2 * b + this.x1 * this._l23_2a - x * this._l12_2a) / m;
            _y2 = (this.y2 * b + this.y1 * this._l23_2a - y * this._l12_2a) / m;
        }
        this.getPath().bezierCurveTo(_x1, _y1, _x2, _y2, this.x2, this.y2);
    }

    @Override
    public void point(double x, double y) {
        if (this.pointStatus > 0) {
            double x23 = this.x2 - x;
            double y23 = this.y2 - y;
            double d = x23 * x23 + y23 * y23;
            double d2 = this.alpha;
            boolean bl = false;
            d = this._l23_2a = Math.pow(d, d2);
            boolean bl2 = false;
            this._l23_a = Math.sqrt(d);
        }
        int n = this.pointStatus;
        switch (n) {
            case 0: {
                this.pointStatus = 1;
                if (this.lineStatus > 0) {
                    this.getPath().lineTo(x, y);
                    break;
                }
                this.getPath().moveTo(x, y);
                break;
            }
            case 1: {
                this.pointStatus = 2;
                break;
            }
            case 2: {
                this.pointStatus = 3;
                this.curve(x, y);
                break;
            }
            default: {
                this.curve(x, y);
            }
        }
        this._l01_a = this._l12_a;
        this._l12_a = this._l23_a;
        this._l01_2a = this._l12_2a;
        this._l12_2a = this._l23_2a;
        this.x0 = this.x1;
        this.x1 = this.x2;
        this.x2 = x;
        this.y0 = this.y1;
        this.y1 = this.y2;
        this.y2 = y;
    }
}

