/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.shape.curve;

import io.data2viz.geom.Path;
import io.data2viz.shape.Curve;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J'\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00110\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/data2viz/shape/curve/Natural;", "Lio/data2viz/shape/Curve;", "path", "Lio/data2viz/geom/Path;", "(Lio/data2viz/geom/Path;)V", "lineStatus", "", "getPath", "()Lio/data2viz/geom/Path;", "x", "", "", "y", "areaEnd", "", "areaStart", "controlPoints", "", "points", "", "(Ljava/util/List;)[[Ljava/lang/Double;", "lineEnd", "lineStart", "point", "shape"})
public final class Natural
implements Curve {
    @NotNull
    private final Path path;
    @NotNull
    private List<Double> x;
    @NotNull
    private List<Double> y;
    private int lineStatus;

    public Natural(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        boolean bl = false;
        this.x = new ArrayList();
        bl = false;
        this.y = new ArrayList();
        this.lineStatus = -1;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public void areaStart() {
        this.lineStatus = 0;
    }

    @Override
    public void areaEnd() {
        this.lineStatus = -1;
    }

    @Override
    public void lineStart() {
        this.x.clear();
        this.y.clear();
    }

    @Override
    public void lineEnd() {
        int n = this.x.size();
        if (n > 0) {
            if (this.lineStatus > 0) {
                this.getPath().lineTo(((Number)this.x.get(0)).doubleValue(), ((Number)this.y.get(0)).doubleValue());
            } else {
                this.getPath().moveTo(((Number)this.x.get(0)).doubleValue(), ((Number)this.y.get(0)).doubleValue());
            }
            if (n > 1) {
                if (n == 2) {
                    this.getPath().lineTo(((Number)this.x.get(1)).doubleValue(), ((Number)this.y.get(1)).doubleValue());
                } else {
                    Double[][] px = this.controlPoints(this.x);
                    Double[][] py = this.controlPoints(this.y);
                    int i0 = 0;
                    int i1 = 0;
                    i1 = 1;
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)n);
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl = false;
                        this.getPath().bezierCurveTo(px[0][i0].doubleValue(), py[0][i0].doubleValue(), px[1][i0].doubleValue(), py[1][i0].doubleValue(), ((Number)this.x.get(i1)).doubleValue(), ((Number)this.y.get(i1)).doubleValue());
                        int n2 = i0;
                        i0 = n2 + 1;
                        n2 = i1;
                        i1 = n2 + 1;
                    }
                }
            }
        }
        if (this.lineStatus > -1) {
            if (this.lineStatus > 0) {
                this.getPath().closePath();
            }
            this.lineStatus = 1 - this.lineStatus;
        }
        this.x.clear();
        this.y.clear();
    }

    private final Double[][] controlPoints(List<Double> points) {
        int i;
        int element$iv;
        int n = points.size() - 1;
        double m = 0.0;
        int n2 = 0;
        int n3 = n;
        Double[] doubleArray = new Double[n3];
        while (n2 < n3) {
            int n4 = n2++;
            doubleArray[n4] = 0.0;
        }
        Double[] a = doubleArray;
        n3 = 0;
        int n5 = n;
        Double[] doubleArray2 = new Double[n5];
        while (n3 < n5) {
            int n6 = n3++;
            doubleArray2[n6] = 0.0;
        }
        Double[] b = doubleArray2;
        n5 = 0;
        int n7 = n;
        Object object = new Double[n7];
        while (n5 < n7) {
            int n8 = n5++;
            object[n8] = 0.0;
        }
        Double[] r = object;
        a[0] = 0.0;
        b[0] = 2.0;
        r[0] = ((Number)points.get(0)).doubleValue() + (double)2 * ((Number)points.get(1)).doubleValue();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)(n - 1));
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            i = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            a[i] = 1.0;
            b[i] = 4.0;
            r[i] = (double)4 * ((Number)points.get(i)).doubleValue() + (double)2 * ((Number)points.get(i + 1)).doubleValue();
        }
        a[n - 1] = 2.0;
        b[n - 1] = 7.0;
        r[n - 1] = (double)8 * ((Number)points.get(n - 1)).doubleValue() + ((Number)points.get(n)).doubleValue();
        $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)n);
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            i = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            m = a[i] / b[i - 1];
            Double[] doubleArray3 = b;
            int n9 = i;
            doubleArray3[n9] = doubleArray3[n9] - m;
            doubleArray3 = r;
            n9 = i;
            doubleArray3[n9] = doubleArray3[n9] - m * r[i - 1];
        }
        a[n - 1] = r[n - 1] / b[n - 1];
        $this$forEach$iv = (Iterable)RangesKt.downTo((int)(n - 2), (int)0);
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            i = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            a[i] = (r[i] - a[i + 1]) / b[i];
        }
        b[n - 1] = (((Number)points.get(n)).doubleValue() + a[n - 1]) / (double)2;
        $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(n - 1));
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            i = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            b[i] = (double)2 * ((Number)points.get(i + 1)).doubleValue() - a[i + 1];
        }
        Double[][] doubleArray4 = new Double[][]{a, b};
        return doubleArray4;
    }

    @Override
    public void point(double x, double y) {
        this.x.add(x);
        this.y.add(y);
    }
}

