/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.dataset.LocallySortedDataset;
import io.datakernel.datagraph.dataset.SortedDataset;
import io.datakernel.datagraph.dataset.impl.DatasetFilter;
import io.datakernel.datagraph.dataset.impl.DatasetJoin;
import io.datakernel.datagraph.dataset.impl.DatasetListConsumer;
import io.datakernel.datagraph.dataset.impl.DatasetListProducer;
import io.datakernel.datagraph.dataset.impl.DatasetLocalSort;
import io.datakernel.datagraph.dataset.impl.DatasetLocalSortReduce;
import io.datakernel.datagraph.dataset.impl.DatasetMap;
import io.datakernel.datagraph.dataset.impl.DatasetRepartitionAndSort;
import io.datakernel.datagraph.dataset.impl.DatasetRepartitionReduce;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.Partition;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.stream.processor.StreamJoin;
import io.datakernel.stream.processor.StreamMap;
import io.datakernel.stream.processor.StreamReducers;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Datasets {
    private Datasets() {
    }

    public static <K, T> SortedDataset<K, T> castToSorted(final Dataset<T> dataset, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return new SortedDataset<K, T>(dataset.valueType(), keyComparator, keyType, keyFunction){

            @Override
            public List<StreamId> channels(DataGraph graph) {
                return dataset.channels(graph);
            }
        };
    }

    public static <K, T> SortedDataset<K, T> castToSorted(final LocallySortedDataset<K, T> dataset) {
        return new SortedDataset<K, T>(dataset.valueType(), dataset.keyComparator(), dataset.keyType(), dataset.keyFunction()){

            @Override
            public List<StreamId> channels(DataGraph graph) {
                return dataset.channels(graph);
            }
        };
    }

    public static <K, L, R, V> SortedDataset<K, V> join(SortedDataset<K, L> left, SortedDataset<K, R> right, StreamJoin.Joiner<K, L, R, V> joiner, Class<V> resultType, Function<V, K> keyFunction) {
        return new DatasetJoin<K, L, R, V>(left, right, joiner, resultType, keyFunction);
    }

    public static <I, O> Dataset<O> map(Dataset<I> dataset, StreamMap.Mapper<I, O> mapper, Class<O> resultType) {
        return new DatasetMap<I, O>(dataset, mapper, resultType);
    }

    public static <I, O> Dataset<O> map(Dataset<I> dataset, final Function<I, O> function, Class<O> resultType) {
        return Datasets.map(dataset, new StreamMap.MapperProjection<I, O>(){

            protected O apply(I input) {
                return function.apply(input);
            }
        }, resultType);
    }

    public static <T> Dataset<T> map(Dataset<T> dataset, StreamMap.Mapper<T, T> mapper) {
        return Datasets.map(dataset, mapper, dataset.valueType());
    }

    public static <T> Dataset<T> map(Dataset<T> dataset, Function<T, T> function) {
        return Datasets.map(dataset, function, dataset.valueType());
    }

    public static <T> Dataset<T> filter(Dataset<T> dataset, Predicate<T> predicate) {
        return new DatasetFilter<T>(dataset, predicate, dataset.valueType());
    }

    public static <K, I> LocallySortedDataset<K, I> localSort(Dataset<I> dataset, Class<K> keyType, Function<I, K> keyFunction, Comparator<K> keyComparator) {
        return new DatasetLocalSort<K, I>(dataset, keyType, keyFunction, keyComparator);
    }

    public static <K, I, O> LocallySortedDataset<K, O> localReduce(LocallySortedDataset<K, I> stream, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, Function<O, K> resultKeyFunction) {
        return new DatasetLocalSortReduce<K, I, O>(stream, reducer, resultType, resultKeyFunction);
    }

    public static <K, I, O> Dataset<O> repartition_Reduce(LocallySortedDataset<K, I> dataset, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType) {
        return new DatasetRepartitionReduce<K, I, O>(dataset, reducer, resultType);
    }

    public static <K, I, O> Dataset<O> repartition_Reduce(LocallySortedDataset<K, I> dataset, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, List<Partition> partitions) {
        return new DatasetRepartitionReduce<K, I, O>(dataset, reducer, resultType, partitions);
    }

    public static <K, T> SortedDataset<K, T> repartition_Sort(LocallySortedDataset<K, T> dataset) {
        return new DatasetRepartitionAndSort<K, T>(dataset);
    }

    public static <K, T> SortedDataset<K, T> repartition_Sort(LocallySortedDataset<K, T> dataset, List<Partition> partitions) {
        return new DatasetRepartitionAndSort<K, T>(dataset, partitions);
    }

    public static <K, I, O, A> Dataset<O> sort_Reduce_Repartition_Reduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, O, A> reducer, Class<K> keyType, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction, Class<O> outputType) {
        LocallySortedDataset<K, I> partiallySorted = Datasets.localSort(dataset, keyType, inputKeyFunction, keyComparator);
        LocallySortedDataset<K, A> partiallyReduced = Datasets.localReduce(partiallySorted, reducer.inputToAccumulator(), accumulatorType, accumulatorKeyFunction);
        return Datasets.repartition_Reduce(partiallyReduced, reducer.accumulatorToOutput(), outputType);
    }

    public static <K, I, A> Dataset<A> sort_Reduce_Repartition_Reduce(Dataset<I> dataset, StreamReducers.ReducerToResult<K, I, A, A> reducer, Class<K> keyType, Function<I, K> inputKeyFunction, Comparator<K> keyComparator, Class<A> accumulatorType, Function<A, K> accumulatorKeyFunction) {
        return Datasets.sort_Reduce_Repartition_Reduce(dataset, reducer, keyType, inputKeyFunction, keyComparator, accumulatorType, accumulatorKeyFunction, accumulatorType);
    }

    public static <K, T> Dataset<T> sort_Reduce_Repartition_Reduce(Dataset<T> dataset, StreamReducers.ReducerToResult<K, T, T, T> reducer, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.sort_Reduce_Repartition_Reduce(dataset, reducer, keyType, keyFunction, keyComparator, dataset.valueType(), keyFunction, dataset.valueType());
    }

    public static <T> Dataset<T> datasetOfList(Object dataId, Class<T> resultType) {
        return new DatasetListProducer<T>(dataId, resultType);
    }

    public static <K, T> SortedDataset<K, T> sortedDatasetOfList(Object dataId, Class<T> resultType, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        return Datasets.castToSorted(Datasets.datasetOfList(dataId, resultType), keyType, keyFunction, keyComparator);
    }

    public static <T> DatasetListConsumer<T> listConsumer(Dataset<T> input, Object listId) {
        return new DatasetListConsumer<T>(input, listId);
    }
}

