/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class DatasetFilter<T>
extends Dataset<T> {
    private final Dataset<T> input;
    private final Predicate<T> predicate;

    public DatasetFilter(Dataset<T> input, Predicate<T> predicate, Class<T> resultType) {
        super(resultType);
        this.input = input;
        this.predicate = predicate;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(graph);
        for (StreamId streamId : streamIds) {
            NodeFilter<T> node = new NodeFilter<T>(this.predicate, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

