/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.SortedDataset;
import io.datakernel.datagraph.dataset.impl.DatasetUtils;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeJoin;
import io.datakernel.stream.processor.StreamJoin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class DatasetJoin<K, L, R, V>
extends SortedDataset<K, V> {
    private final SortedDataset<K, L> left;
    private final SortedDataset<K, R> right;
    private final StreamJoin.Joiner<K, L, R, V> joiner;

    public DatasetJoin(SortedDataset<K, L> left, SortedDataset<K, R> right, StreamJoin.Joiner<K, L, R, V> joiner, Class<V> resultType, Function<V, K> keyFunction) {
        super(resultType, left.keyComparator(), left.keyType(), keyFunction);
        this.left = left;
        this.right = right;
        this.joiner = joiner;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> leftStreamIds = this.left.channels(graph);
        List<StreamId> rightStreamIds = DatasetUtils.repartitionAndSort(graph, this.right, graph.getPartitions(leftStreamIds));
        assert (leftStreamIds.size() == rightStreamIds.size());
        for (int i = 0; i < leftStreamIds.size(); ++i) {
            StreamId leftStreamId = leftStreamIds.get(i);
            StreamId rightStreamId = rightStreamIds.get(i);
            NodeJoin node = new NodeJoin(leftStreamId, rightStreamId, this.left.keyComparator(), this.left.keyFunction(), this.right.keyFunction(), this.joiner);
            graph.addNode(graph.getPartition(leftStreamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

