/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.Partition;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeProducerOfIterable;
import java.util.ArrayList;
import java.util.List;

public final class DatasetListProducer<T>
extends Dataset<T> {
    private final Object listId;

    public DatasetListProducer(Object listId, Class<T> resultType) {
        super(resultType);
        this.listId = listId;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<Partition> availablePartitions = graph.getAvailablePartitions();
        for (Partition partition : availablePartitions) {
            NodeProducerOfIterable node = new NodeProducerOfIterable(this.listId);
            graph.addNode(partition, node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

