/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.dataset.LocallySortedDataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeSort;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class DatasetLocalSort<K, T>
extends LocallySortedDataset<K, T> {
    private final Dataset<T> input;

    public DatasetLocalSort(Dataset<T> input, Class<K> keyType, Function<T, K> keyFunction, Comparator<K> keyComparator) {
        super(input.valueType(), keyComparator, keyType, keyFunction);
        this.input = input;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(graph);
        for (StreamId streamId : streamIds) {
            NodeSort node = new NodeSort(this.keyFunction(), this.keyComparator(), false, 10, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

