/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.LocallySortedDataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeReduceSimple;
import io.datakernel.stream.processor.StreamReducers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public final class DatasetLocalSortReduce<K, I, O>
extends LocallySortedDataset<K, O> {
    private final LocallySortedDataset<K, I> input;
    private final StreamReducers.Reducer<K, I, O, ?> reducer;

    public DatasetLocalSortReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, Function<O, K> resultKeyFunction) {
        super(resultType, input.keyComparator(), input.keyType(), resultKeyFunction);
        this.input = input;
        this.reducer = reducer;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        for (StreamId streamId : this.input.channels(graph)) {
            NodeReduceSimple node = new NodeReduceSimple(this.input.keyFunction(), this.input.keyComparator(), this.reducer);
            node.addInput(streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

