/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.NodeMap;
import io.datakernel.stream.processor.StreamMap;
import java.util.ArrayList;
import java.util.List;

public final class DatasetMap<I, O>
extends Dataset<O> {
    private final Dataset<I> input;
    private final StreamMap.Mapper<I, O> mapper;

    public DatasetMap(Dataset<I> input, StreamMap.Mapper<I, O> mapper, Class<O> resultType) {
        super(resultType);
        this.input = input;
        this.mapper = mapper;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        ArrayList<StreamId> outputStreamIds = new ArrayList<StreamId>();
        List<StreamId> streamIds = this.input.channels(graph);
        for (StreamId streamId : streamIds) {
            NodeMap<I, O> node = new NodeMap<I, O>(this.mapper, streamId);
            graph.addNode(graph.getPartition(streamId), node);
            outputStreamIds.add(node.getOutput());
        }
        return outputStreamIds;
    }
}

