/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.dataset.impl;

import io.datakernel.datagraph.dataset.Dataset;
import io.datakernel.datagraph.dataset.LocallySortedDataset;
import io.datakernel.datagraph.dataset.impl.DatasetUtils;
import io.datakernel.datagraph.graph.DataGraph;
import io.datakernel.datagraph.graph.Partition;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.stream.processor.StreamReducers;
import java.util.List;

public final class DatasetRepartitionReduce<K, I, O>
extends Dataset<O> {
    private final LocallySortedDataset<K, I> input;
    private final StreamReducers.Reducer<K, I, O, ?> reducer;
    private final List<Partition> partitions;

    public DatasetRepartitionReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType) {
        this(input, reducer, resultType, null);
    }

    public DatasetRepartitionReduce(LocallySortedDataset<K, I> input, StreamReducers.Reducer<K, I, O, ?> reducer, Class<O> resultType, List<Partition> partitions) {
        super(resultType);
        this.input = input;
        this.reducer = reducer;
        this.partitions = partitions;
    }

    @Override
    public List<StreamId> channels(DataGraph graph) {
        return DatasetUtils.repartitionAndReduce(graph, this.input, this.reducer, this.partitions == null || this.partitions.isEmpty() ? graph.getAvailablePartitions() : this.partitions);
    }
}

