/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.graph;

import com.google.gson.TypeAdapter;
import io.datakernel.datagraph.graph.Partition;
import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.node.Node;
import io.datakernel.datagraph.server.DatagraphSerialization;
import io.datakernel.util.gson.GsonAdapters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataGraph {
    private final DatagraphSerialization serialization;
    private final List<Partition> availablePartitions;
    private final Map<Node, Partition> nodePartitions = new LinkedHashMap<Node, Partition>();
    private final Map<StreamId, Node> streams = new LinkedHashMap<StreamId, Node>();
    private final TypeAdapter<List<Node>> listNodeAdapter;

    public DataGraph(DatagraphSerialization serialization, List<Partition> availablePartitions) {
        this.serialization = serialization;
        this.availablePartitions = availablePartitions;
        this.listNodeAdapter = GsonAdapters.indent((TypeAdapter)GsonAdapters.ofList(serialization.nodeAdapter), (String)"  ");
    }

    public List<Partition> getAvailablePartitions() {
        return this.availablePartitions;
    }

    public Partition getPartition(Node node) {
        return this.nodePartitions.get(node);
    }

    public Partition getPartition(StreamId streamId) {
        return this.getPartition(this.streams.get(streamId));
    }

    private Map<Partition, List<Node>> getNodesByPartition() {
        HashMap<Partition, List<Node>> listMultimap = new HashMap<Partition, List<Node>>();
        for (Map.Entry<Node, Partition> entry : this.nodePartitions.entrySet()) {
            listMultimap.computeIfAbsent(entry.getValue(), partition -> new ArrayList()).add(entry.getKey());
        }
        return listMultimap;
    }

    public void execute() {
        Map<Partition, List<Node>> map = this.getNodesByPartition();
        for (Partition partition : map.keySet()) {
            List<Node> nodes = map.get(partition);
            partition.execute(nodes);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<Partition, List<Node>> map = this.getNodesByPartition();
        for (Partition partition : map.keySet()) {
            List<Node> nodes = map.get(partition);
            sb.append("--- ").append(partition).append("\n\n");
            sb.append(GsonAdapters.toJson(this.listNodeAdapter, nodes));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public void addNode(Partition partition, Node node) {
        this.nodePartitions.put(node, partition);
        for (StreamId streamId : node.getOutputs()) {
            this.streams.put(streamId, node);
        }
    }

    public void addNodeStream(Node node, StreamId streamId) {
        this.streams.put(streamId, node);
    }

    public List<Partition> getPartitions(List<? extends StreamId> channels) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (StreamId streamId : channels) {
            Partition partition = this.getPartition(streamId);
            partitions.add(partition);
        }
        return partitions;
    }

    public DatagraphSerialization getSerialization() {
        return this.serialization;
    }
}

