/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.graph;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.server.DatagraphEnvironment;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamProducer;
import io.datakernel.util.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TaskContext {
    private final DatagraphEnvironment environment;
    private final Eventloop eventloop;
    private final Map<StreamId, StreamProducer<?>> producers = new LinkedHashMap();
    private final Map<StreamId, StreamConsumer<?>> consumers = new LinkedHashMap();

    public TaskContext(Eventloop eventloop, DatagraphEnvironment environment) {
        this.environment = environment;
        this.eventloop = eventloop;
    }

    public DatagraphEnvironment environment() {
        return this.environment;
    }

    public Eventloop getEventloop() {
        return this.eventloop;
    }

    public <T> void bindChannel(StreamId streamId, StreamConsumer<T> consumer) {
        Preconditions.checkState((!this.consumers.containsKey(streamId) ? 1 : 0) != 0);
        this.consumers.put(streamId, consumer);
    }

    public <T> void export(StreamId streamId, StreamProducer<T> producer) {
        Preconditions.checkState((!this.producers.containsKey(streamId) ? 1 : 0) != 0);
        this.producers.put(streamId, producer);
    }

    public void wireAll() {
        for (StreamId streamId : this.producers.keySet()) {
            StreamProducer<?> producer = this.producers.get(streamId);
            StreamConsumer<?> consumer = this.consumers.get(streamId);
            Preconditions.checkNotNull(producer);
            Preconditions.checkNotNull(consumer, (String)"Consumer not found for %s , producer %s", (Object[])new Object[]{streamId, producer});
            producer.streamTo(consumer);
        }
    }
}

