/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.StreamConsumer;
import io.datakernel.stream.StreamConsumerToList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class NodeConsumerToList<T>
implements Node {
    private Object listId;
    private StreamId input;

    public NodeConsumerToList() {
    }

    public NodeConsumerToList(StreamId input, Object listId) {
        this.listId = listId;
        this.input = input;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamConsumerToList consumer;
        ArrayList object = taskContext.environment().get(this.listId);
        if (object == null) {
            object = new ArrayList();
            taskContext.environment().set(this.listId, object);
        }
        if (object instanceof List) {
            consumer = StreamConsumerToList.create((List)object);
        } else if (object instanceof StreamConsumer) {
            consumer = (StreamConsumer)object;
        } else {
            throw new IllegalArgumentException();
        }
        taskContext.bindChannel(this.input, consumer);
    }

    public Object getListId() {
        return this.listId;
    }

    public void setListId(Object listId) {
        this.listId = listId;
    }

    public StreamId getInput() {
        return this.input;
    }

    public void setInput(StreamId input) {
        this.input = input;
    }
}

