/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.datagraph.server.DatagraphClient;
import io.datakernel.stream.StreamProducer;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;

public final class NodeDownload<T>
implements Node {
    private Class<T> type;
    private InetSocketAddress address;
    private StreamId streamId;
    private StreamId output;

    public NodeDownload() {
    }

    public NodeDownload(Class<T> type, InetSocketAddress address, StreamId streamId) {
        this.type = type;
        this.address = address;
        this.streamId = streamId;
        this.output = new StreamId();
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.streamId);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        DatagraphClient client = taskContext.environment().getInstance(DatagraphClient.class);
        StreamProducer stream = StreamProducer.ofStage(client.download(this.address, this.streamId, this.type));
        taskContext.export(this.output, stream);
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public StreamId getStreamId() {
        return this.streamId;
    }

    public void setStreamId(StreamId streamId) {
        this.streamId = streamId;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public String toString() {
        return "NodeDownload{type=" + this.type + ", address=" + this.address + ", streamId=" + this.streamId + ", output=" + this.output + '}';
    }
}

