/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;

public final class NodeFilter<T>
implements Node {
    private Predicate<T> predicate;
    private StreamId input;
    private StreamId output = new StreamId();

    public NodeFilter() {
    }

    public NodeFilter(Predicate<T> predicate, StreamId input) {
        this.predicate = predicate;
        this.input = input;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamFilter streamFilter = StreamFilter.create(this.predicate);
        taskContext.bindChannel(this.input, streamFilter.getInput());
        taskContext.export(this.output, streamFilter.getOutput());
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public StreamId getInput() {
        return this.input;
    }

    public void setInput(StreamId input) {
        this.input = input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public String toString() {
        return "NodeFilter{predicate=" + this.predicate + ", input=" + this.input + ", output=" + this.output + '}';
    }
}

