/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamJoin;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Function;

public final class NodeJoin<K, L, R, V>
implements Node {
    private StreamId left;
    private StreamId right;
    private StreamId output;
    private Comparator<K> keyComparator;
    private Function<L, K> leftKeyFunction;
    private Function<R, K> rightKeyFunction;
    private StreamJoin.Joiner<K, L, R, V> joiner;

    public NodeJoin() {
    }

    public NodeJoin(StreamId left, StreamId right, Comparator<K> keyComparator, Function<L, K> leftKeyFunction, Function<R, K> rightKeyFunction, StreamJoin.Joiner<K, L, R, V> joiner) {
        this.left = left;
        this.right = right;
        this.output = new StreamId();
        this.keyComparator = keyComparator;
        this.leftKeyFunction = leftKeyFunction;
        this.rightKeyFunction = rightKeyFunction;
        this.joiner = joiner;
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamJoin join = StreamJoin.create(this.keyComparator, this.leftKeyFunction, this.rightKeyFunction, this.joiner);
        taskContext.export(this.output, join.getOutput());
        taskContext.bindChannel(this.left, join.getLeft());
        taskContext.bindChannel(this.right, join.getRight());
    }

    public StreamId getLeft() {
        return this.left;
    }

    public void setLeft(StreamId left) {
        this.left = left;
    }

    public StreamId getRight() {
        return this.right;
    }

    public void setRight(StreamId right) {
        this.right = right;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public Function<L, K> getLeftKeyFunction() {
        return this.leftKeyFunction;
    }

    public void setLeftKeyFunction(Function<L, K> leftKeyFunction) {
        this.leftKeyFunction = leftKeyFunction;
    }

    public Function<R, K> getRightKeyFunction() {
        return this.rightKeyFunction;
    }

    public void setRightKeyFunction(Function<R, K> rightKeyFunction) {
        this.rightKeyFunction = rightKeyFunction;
    }

    public StreamJoin.Joiner<K, L, R, V> getJoiner() {
        return this.joiner;
    }

    public void setJoiner(StreamJoin.Joiner<K, L, R, V> joiner) {
        this.joiner = joiner;
    }
}

