/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamMap;
import java.util.Collection;
import java.util.Collections;

public final class NodeMap<I, O>
implements Node {
    private StreamMap.Mapper<I, O> mapper;
    private StreamId input;
    private StreamId output;

    public NodeMap() {
    }

    public NodeMap(StreamMap.Mapper<I, O> mapper, StreamId input) {
        this.mapper = mapper;
        this.input = input;
        this.output = new StreamId();
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamMap streamMap = StreamMap.create(this.mapper);
        taskContext.bindChannel(this.input, streamMap.getInput());
        taskContext.export(this.output, streamMap.getOutput());
    }

    public StreamMap.Mapper<I, O> getMapper() {
        return this.mapper;
    }

    public void setMapper(StreamMap.Mapper<I, O> mapper) {
        this.mapper = mapper;
    }

    public StreamId getInput() {
        return this.input;
    }

    public void setInput(StreamId input) {
        this.input = input;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }

    public String toString() {
        return "NodeMap{mapper=" + this.mapper + ", input=" + this.input + ", output=" + this.output + '}';
    }
}

