/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.processor.StreamMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class NodeMerge<K, T>
implements Node {
    private Function<T, K> keyFunction;
    private Comparator<K> keyComparator;
    private boolean deduplicate;
    private List<StreamId> inputs;
    private StreamId output;

    public NodeMerge() {
    }

    public NodeMerge(Function<T, K> keyFunction, Comparator<K> keyComparator, boolean deduplicate) {
        this.keyFunction = keyFunction;
        this.keyComparator = keyComparator;
        this.deduplicate = deduplicate;
        this.inputs = new ArrayList<StreamId>();
        this.output = new StreamId();
    }

    public void addInput(StreamId input) {
        this.inputs.add(input);
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamMerger streamMerger = StreamMerger.create(this.keyFunction, this.keyComparator, (boolean)this.deduplicate);
        for (StreamId input : this.inputs) {
            taskContext.bindChannel(input, streamMerger.newInput());
        }
        taskContext.export(this.output, streamMerger.getOutput());
    }

    public Function<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    public void setKeyFunction(Function<T, K> keyFunction) {
        this.keyFunction = keyFunction;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    public List<StreamId> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<StreamId> inputs) {
        this.inputs = inputs;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }
}

