/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.datagraph.node;

import io.datakernel.datagraph.graph.StreamId;
import io.datakernel.datagraph.graph.TaskContext;
import io.datakernel.datagraph.node.Node;
import io.datakernel.stream.StreamProducer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class NodeProducerOfIterable<T>
implements Node {
    private Object iterableId;
    private StreamId output;

    public NodeProducerOfIterable() {
    }

    public NodeProducerOfIterable(Object iterableId) {
        this.iterableId = iterableId;
        this.output = new StreamId();
    }

    @Override
    public Collection<StreamId> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void createAndBind(TaskContext taskContext) {
        StreamProducer producer;
        Object object = taskContext.environment().get(this.iterableId);
        if (object instanceof Iterator) {
            producer = StreamProducer.ofIterator((Iterator)((Iterator)object));
        } else if (object instanceof Iterable) {
            producer = StreamProducer.ofIterable((Iterable)((Iterable)object));
        } else {
            throw new IllegalArgumentException();
        }
        taskContext.export(this.output, producer);
    }

    public Object getIterableId() {
        return this.iterableId;
    }

    public void setIterableId(Object iterableId) {
        this.iterableId = iterableId;
    }

    public StreamId getOutput() {
        return this.output;
    }

    public void setOutput(StreamId output) {
        this.output = output;
    }
}

